/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fGrayedColor;
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        super(317758860951554L, 1);
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isDifferentScope(IType type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        IRubyElement input = this.fHierarchy.getInputElement();
        if (input == null || input.getElementType() == 5) {
            return false;
        }
        IRubyElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 3 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    public String getText(Object element) {
        String text = super.getText(element);
        return this.decorateText(text, element);
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = RubyPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new RubyElementImageDescriptor(RubyPluginImages.DESC_OBJS_CLASS, 0, RubyElementImageProvider.BIG_SIZE);
        }
        boolean isModule = type.isModule();
        boolean isInner = type.getDeclaringType() != null;
        ImageDescriptor desc = RubyElementImageProvider.getTypeImageDescriptor(isModule, isInner, this.isDifferentScope(type));
        int adornmentFlags = 0;
        return new RubyElementImageDescriptor(desc, adornmentFlags, RubyElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof IType && this.isDifferentScope((IType)element)) {
            if (this.fGrayedColor == null) {
                this.fGrayedColor = Display.getCurrent().getSystemColor(16);
            }
            return this.fGrayedColor;
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
            this.drawImage(this.getImageData(RubyPluginImages.DESC_OVR_FOCUS), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor descriptor) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                RubyPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
            }
            return data;
        }

        protected Point getSize() {
            return RubyElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && FocusDescriptor.class.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase);
        }
    }
}

