/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.template.contentassist;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.rubypeople.rdt.internal.ui.text.template.contentassist.RubyTemplateAccess;

public class RubyTemplateVariableTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
        try {
            IDocument doc = textViewer.getDocument();
            int offset = subject.getOffset();
            if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                String varName = doc.get(offset, subject.getLength());
                TemplateContextType contextType = RubyTemplateAccess.getDefault().getContextTypeRegistry().getContextType("ruby");
                if (contextType != null) {
                    Iterator iter = contextType.resolvers();
                    while (iter.hasNext()) {
                        TemplateVariableResolver var = (TemplateVariableResolver)iter.next();
                        if (!varName.equals(var.getType())) continue;
                        return var.getDescription();
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            IDocument document = textViewer.getDocument();
            int start = -1;
            int end = -1;
            try {
                char c;
                int pos = offset;
                while (pos >= 0) {
                    c = document.getChar(pos);
                    if (c != '.' && c != '-' && c != '/' && c != '\\' && !Character.isJavaIdentifierPart(c)) break;
                    --pos;
                }
                start = pos;
                pos = offset;
                int length = document.getLength();
                while (pos < length) {
                    c = document.getChar(pos);
                    if (c != '.' && c != '-' && !Character.isJavaIdentifierPart(c)) break;
                    ++pos;
                }
                end = pos;
            }
            catch (BadLocationException badLocationException) {}
            if (start > -1 && end > -1) {
                if (start == offset && end == offset) {
                    return new Region(offset, 0);
                }
                if (start == offset) {
                    return new Region(start, end - start);
                }
                return new Region(start + 1, end - start - 1);
            }
            return null;
        }
        return null;
    }
}

