/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.template.contentassist;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContextType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.ui.extensions.IRubyTemplateProvider;

public class RubyTemplateAccess {
    private static final String CUSTOM_TEMPLATES_KEY = "org.rubypeople.rdt.ui.customtemplates";
    private static RubyTemplateAccess fgInstance;
    private TemplateStore fStore;
    private ContributionContextTypeRegistry fContextTypeRegistry;

    private RubyTemplateAccess() {
    }

    public static RubyTemplateAccess getDefault() {
        if (fgInstance == null) {
            fgInstance = new RubyTemplateAccess();
        }
        return fgInstance;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), RubyPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                RubyPlugin.log(e);
            }
            TemplatePersistenceData[] tempData = this.getExtensionTemplateData();
            if (tempData != null) {
                int i = 0;
                while (i < tempData.length) {
                    this.fStore.add(tempData[i]);
                    ++i;
                }
            }
        }
        return this.fStore;
    }

    private TemplatePersistenceData[] getExtensionTemplateData() {
        ArrayList<IRubyTemplateProvider> extensions = new ArrayList<IRubyTemplateProvider>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint[] points = reg.getExtensionPoints("org.rubypeople.rdt.ui");
        IExtensionPoint point = null;
        if (points != null) {
            int i = 0;
            while (i < points.length) {
                IExtensionPoint currentPoint = points[i];
                if (currentPoint.getUniqueIdentifier().endsWith("rubyTemplateProvider")) {
                    point = currentPoint;
                    break;
                }
                ++i;
            }
            if (point != null) {
                IExtension[] exts = point.getExtensions();
                IRubyTemplateProvider prov = null;
                int i2 = 0;
                while (i2 < exts.length) {
                    IConfigurationElement[] elem = exts[i2].getConfigurationElements();
                    elem[0].getAttributeNames();
                    try {
                        Object tempProv = elem[0].createExecutableExtension("class");
                        if (tempProv instanceof IRubyTemplateProvider) {
                            prov = (IRubyTemplateProvider)tempProv;
                            extensions.add(prov);
                        }
                    }
                    catch (CoreException e) {
                        RubyPlugin.log(e);
                    }
                    ++i2;
                }
            }
        }
        if (extensions.size() > 0) {
            int i = 0;
            while (i < extensions.size()) {
                IRubyTemplateProvider currentProvider = (IRubyTemplateProvider)extensions.get(i);
                TemplatePersistenceData[] templates = currentProvider.getTemplateData();
                if (templates != null) {
                    return templates;
                }
                ++i;
            }
        }
        return null;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new RubyContextType());
        }
        return this.fContextTypeRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public void savePluginPreferences() {
        RubyPlugin.getDefault().savePluginPreferences();
    }
}

