/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.rubypeople.rdt.internal.ui.text.spelling.RubySpellingProblem;
import org.rubypeople.rdt.internal.ui.text.spelling.SpellCheckEngine;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.rubypeople.rdt.ui.PreferenceConstants;

public abstract class SpellingEngine
implements ISpellingEngine {
    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        IPreferenceStore preferences = PreferenceConstants.getPreferenceStore();
        if (collector != null) {
            Locale locale = this.getLocale(preferences);
            ISpellChecker checker = SpellCheckEngine.getInstance().createSpellChecker(locale, preferences);
            if (checker != null) {
                this.check(document, regions, checker, locale, collector, monitor);
            }
        }
    }

    protected abstract void check(IDocument var1, IRegion[] var2, ISpellChecker var3, Locale var4, ISpellingProblemCollector var5, IProgressMonitor var6);

    private Locale getLocale(IPreferenceStore preferences) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        String locale = preferences.getString("spelling_locale");
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return defaultLocale;
    }

    protected static class SpellEventListener
    implements ISpellEventListener {
        private ISpellingProblemCollector fCollector;

        public SpellEventListener(ISpellingProblemCollector collector) {
            this.fCollector = collector;
        }

        public void handle(ISpellEvent event) {
            this.fCollector.accept((SpellingProblem)new RubySpellingProblem(event));
        }
    }
}

