/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.codemanipulation.StubUtility;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractRubyEditorTextHover;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.SourceViewerInformationControl;

public class RubySourceHover
extends AbstractRubyEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    protected String getHoverInfo(IRubyElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IRubyElement curr = result[0];
        if (curr instanceof IMember && curr instanceof ISourceReference) {
            String source;
            block7: {
                try {
                    source = ((ISourceReference)curr).getSource();
                    if (source != null) break block7;
                    return null;
                }
                catch (RubyModelException rubyModelException) {}
            }
            source = this.removeLeadingComments(source);
            String delim = StubUtility.getLineDelimiterUsed(result[0]);
            String[] sourceLines = Strings.convertIntoLines(source);
            String firstLine = sourceLines[0];
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = "";
            }
            Strings.trimIndentation(sourceLines, curr.getRubyProject());
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = firstLine;
            }
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    private String removeLeadingComments(String source) {
        return source;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = RubySourceHover.this.getEditor();
                int shellStyle = 12;
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, 0, RubySourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 768;
                int shellStyle = 20;
                IEditorPart editor = RubySourceHover.this.getEditor();
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

