/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractReusableInformationControlCreator;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.BrowserInformationControl;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyTypeHover;
import org.rubypeople.rdt.ui.text.ruby.hover.IRubyEditorTextHover;

public class RubyInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected IEditorPart fEditor;
    protected IPartListener fPartListener;
    protected String fCurrentPerspective;
    protected IRubyEditorTextHover fImplementation;
    private IInformationControlCreator fPresenterControlCreator;

    public RubyInformationProvider(IEditorPart editor) {
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != perspectiveId) {
                this.fCurrentPerspective = perspectiveId;
                this.fImplementation = new RubyTypeHover();
                this.fImplementation.setEditor(this.fEditor);
            }
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return RubyWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this.fImplementation != null && (s = this.fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    int shellStyle = 20;
                    int style = 768;
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, shellStyle, style);
                    }
                    return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == RubyInformationProvider.this.fEditor) {
                RubyInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(RubyInformationProvider.this.fPartListener);
                RubyInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            RubyInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            RubyInformationProvider.this.update();
        }
    }
}

