/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyTokenScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyTokenScanner;
import org.rubypeople.rdt.ui.text.IColorManager;

public class RubyColoringTokenScanner
extends AbstractRubyTokenScanner {
    private static String[] fgTokenProperties = new String[]{"color_ruby_keyword", "color_ruby_default", "color_ruby_fixnum", "color_ruby_character", "color_ruby_symbol", "color_ruby_instance_variable", "color_ruby_global", "color_ruby_error"};
    private ITokenScanner fScanner = new RubyTokenScanner();

    public RubyColoringTokenScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    public int getTokenLength() {
        return this.fScanner.getTokenLength();
    }

    public int getTokenOffset() {
        return this.fScanner.getTokenOffset();
    }

    public IToken nextToken() {
        IToken intToken = this.fScanner.nextToken();
        if (intToken == null || intToken.isEOF()) {
            return Token.EOF;
        }
        Integer data = (Integer)intToken.getData();
        if (data == null) {
            return Token.EOF;
        }
        if (this.isKeyword(data)) {
            return this.getToken("color_ruby_keyword");
        }
        switch (data) {
            case 128: {
                return this.getToken("color_ruby_character");
            }
            case 378: 
            case 379: {
                return this.getToken("color_ruby_fixnum");
            }
            case 364: {
                return this.getToken("color_ruby_symbol");
            }
            case 308: {
                return this.getToken("color_ruby_global");
            }
            case 309: {
                return this.getToken("color_ruby_instance_variable");
            }
            case 256: {
                return this.getToken("color_ruby_error");
            }
        }
        return this.getToken("color_ruby_default");
    }

    private boolean isKeyword(int i) {
        return i >= 257 && i <= 303;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }
}

