/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;
import org.rubypeople.rdt.internal.ui.text.RubyIndenter;

public class RubyAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy
implements IPropertyChangeListener {
    private static final String END_STATEMENTS = "endStatements";
    private final Pattern openBlockPattern = Pattern.compile(".*[\\S].*do[\\w|\\s]*");
    private static final String BLOCK_CLOSER = "end";
    private String fPartitioning;
    private final IRubyProject fProject;
    private boolean endStatements;
    private IPreferenceStore fPreferenceStore;

    public RubyAutoIndentStrategy(String partitioning, IRubyProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
        this.fPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        this.endStatements = this.fPreferenceStore.getBoolean(END_STATEMENTS);
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        }
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        RubyHeuristicScanner scanner = new RubyHeuristicScanner(d);
        RubyIndenter indenter = new RubyIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion currentLineRegion = d.getLineInformation(line);
            int lineEnd = currentLineRegion.getOffset() + currentLineRegion.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int startOfCurrentLine = currentLineRegion.getOffset();
            String trimmed = this.getTrimmedLine(d, startOfCurrentLine, c.offset);
            if (this.mightHaveToShiftCurrentLine(trimmed)) {
                IRegion previousLineRegion = d.getLineInformation(line - 1);
                String previousLine = this.getTrimmedLine(d, previousLineRegion.getOffset(), previousLineRegion.getOffset() + previousLineRegion.getLength());
                String previousIndent = indenter.computeIndentation(previousLineRegion.getOffset()).toString();
                String unindented = "";
                if (this.middleOfBlockRightAfterBeginning(trimmed, previousLine)) {
                    unindented = previousIndent;
                    if (this.whenAfterCase(trimmed, previousLine) && RubyCore.getPlugin().getPluginPreferences().getBoolean("org.rubypeople.rdt.core.formatter.indent_case_body")) {
                        unindented = String.valueOf(unindented) + CodeFormatterUtil.createIndentString(1, this.fProject);
                    }
                } else {
                    int length = previousIndent.length() - CodeFormatterUtil.createIndentString(1, this.fProject).length();
                    int nextCalculated = this.nextMeaningfulIndentLength(d, indenter, line);
                    int unit = CodeFormatterUtil.createIndentString(1, this.fProject).length();
                    unindented = nextCalculated != -1 && length > nextCalculated + unit ? previousIndent.substring(0, length - unit) : (length <= 0 ? "" : previousIndent.substring(0, length));
                }
                if (unindented.length() < indent.length()) {
                    d.replace(startOfCurrentLine, c.offset - startOfCurrentLine, String.valueOf(unindented) + trimmed);
                    int shift = indent.length() - unindented.length();
                    c.offset -= shift;
                    buf.delete(buf.length() - shift, buf.length());
                }
            }
            if (this.atIndentPoint(trimmed)) {
                buf.append(CodeFormatterUtil.createIndentString(1, this.fProject));
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
            }
            if (trimmed.equals("=begin")) {
                buf.append(CodeFormatterUtil.createIndentString(1, this.fProject));
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                buf.append("=end");
            }
            if (this.closeBlock() && this.unclosedBlock(d, trimmed, c.offset)) {
                if (lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                buf.append(indent);
                buf.append(BLOCK_CLOSER);
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            RubyPlugin.log(e);
        }
    }

    private int nextMeaningfulIndentLength(IDocument d, RubyIndenter indenter, int line) throws BadLocationException {
        int i = line + 1;
        while (i < d.getNumberOfLines()) {
            IRegion nextLineRegion = d.getLineInformation(i);
            String trimmed = this.getTrimmedLine(d, nextLineRegion.getOffset(), nextLineRegion.getOffset() + nextLineRegion.getLength());
            if (trimmed != null && trimmed.length() != 0) {
                String nextIndent = indenter.computeIndentation(nextLineRegion.getOffset()).toString();
                return nextIndent.length();
            }
            ++i;
        }
        return -1;
    }

    private boolean middleOfBlockRightAfterBeginning(String trimmed, String previousLine) {
        return this.middleOfIfRightAfterBeginning(trimmed, previousLine) || this.middleOfBeginRightAfterBeginning(trimmed, previousLine) || this.elseRightAfterElsif(trimmed, previousLine) || this.ensureRightAfterRescue(trimmed, previousLine) || this.whenAfterCase(trimmed, previousLine) || this.elsifRightAfterElsif(trimmed, previousLine);
    }

    private boolean middleOfBeginRightAfterBeginning(String trimmed, String previousLine) {
        return previousLine.equals("begin") && (trimmed.startsWith("rescue") || trimmed.equals("ensure") || trimmed.equals("rescue"));
    }

    private boolean middleOfIfRightAfterBeginning(String trimmed, String previousLine) {
        return previousLine.startsWith("if ") && (trimmed.startsWith("elsif") || trimmed.equals("else"));
    }

    private boolean ensureRightAfterRescue(String trimmed, String previousLine) {
        return (previousLine.startsWith("rescue ") || previousLine.equals("rescue")) && trimmed.equals("ensure");
    }

    private boolean elseRightAfterElsif(String trimmed, String previousLine) {
        return previousLine.startsWith("elsif ") && trimmed.equals("else");
    }

    private boolean elsifRightAfterElsif(String trimmed, String previousLine) {
        return previousLine.startsWith("elsif ") && trimmed.startsWith("elsif ");
    }

    private boolean whenAfterCase(String trimmed, String previousLine) {
        return previousLine.startsWith("case ") && trimmed.startsWith("when ");
    }

    private boolean atIndentPoint(String trimmed) {
        if (trimmed == null || trimmed.length() == 0) {
            return false;
        }
        return this.atStartOfBlock(trimmed) || this.isMiddleOfBlockKeyword(trimmed);
    }

    private boolean isMiddleOfBlockKeyword(String trimmed) {
        if (trimmed == null || trimmed.length() == 0) {
            return false;
        }
        return trimmed.equals("rescue") || trimmed.equals("else") || trimmed.equals("ensure") || trimmed.startsWith("elsif ") || trimmed.startsWith("rescue ") || trimmed.startsWith("when ");
    }

    private boolean mightHaveToShiftCurrentLine(String trimmed) {
        if (trimmed == null || trimmed.length() == 0) {
            return false;
        }
        return this.isMiddleOfBlockKeyword(trimmed) || trimmed.equals(BLOCK_CLOSER);
    }

    private boolean unclosedBlock(IDocument d, String trimmed, int offset) {
        if (!this.atStartOfBlock(trimmed)) {
            return false;
        }
        RubyParser parser = new RubyParser();
        try {
            parser.parse(d.get());
        }
        catch (SyntaxException e) {
            String msg = e.getMessage();
            if (msg.contains("expecting") && (msg.contains("kEND") || msg.contains("kTHEN"))) {
                return true;
            }
            try {
                StringBuffer buffer = new StringBuffer(d.get());
                buffer.insert(offset, String.valueOf(TextUtilities.getDefaultLineDelimiter((IDocument)d)) + BLOCK_CLOSER);
                parser.parse(buffer.toString());
            }
            catch (SyntaxException syntaxException) {
                return false;
            }
            return true;
        }
        return false;
    }

    private String getTrimmedLine(IDocument d, int start, int offset) throws BadLocationException {
        String line = d.get(start, offset - start);
        return line.trim();
    }

    private boolean atStartOfBlock(String line) {
        return line.startsWith("class ") || line.startsWith("if ") || line.startsWith("module ") || line.startsWith("unless ") || line.startsWith("def ") || line.equals("begin") || line.startsWith("case ") || line.startsWith("for ") || this.openBlockPattern.matcher(line).matches();
    }

    private boolean closeBlock() {
        return this.endStatements;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (END_STATEMENTS.equals(property)) {
            this.endStatements = this.fPreferenceStore.getBoolean(property);
            return;
        }
    }
}

