/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RDocUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.infoviews.RiUtility;

public class ProposalInfo {
    private boolean fRubydocResolved = false;
    private String fRubydoc = null;
    protected IRubyElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IRubyElement getRubyElement() throws RubyModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor monitor) {
        if (!this.fRubydocResolved) {
            this.fRubydocResolved = true;
            this.fRubydoc = this.computeInfo(monitor);
        }
        return this.fRubydoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        block7: {
            String riResult;
            block9: {
                IMethod method;
                IType type;
                IMember member;
                block8: {
                    IRubyElement rubyElement = this.getRubyElement();
                    if (!(rubyElement instanceof IMember)) break block7;
                    member = (IMember)rubyElement;
                    String inSource = this.extractRubydoc(member, monitor);
                    if (inSource != null && inSource.trim().length() > 0) {
                        return inSource;
                    }
                    type = member.getDeclaringType();
                    if (type != null) break block8;
                    return null;
                }
                ArrayList<String> args = new ArrayList<String>();
                String divider = "#";
                if (member instanceof IMethod && (method = (IMethod)member).isSingleton()) {
                    divider = "::";
                }
                args.add(String.valueOf(type.getFullyQualifiedName()) + divider + member.getElementName());
                riResult = RiUtility.getRIHTMLContents(args);
                if (!riResult.trim().equals("nil")) break block9;
                return null;
            }
            try {
                riResult = riResult.replace("color: #00ffff", "font-weight: bold");
                riResult = riResult.replace("color: #ffff00", "font-weight: italic");
                return riResult;
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            catch (IOException e) {
                RubyPlugin.log(e);
            }
        }
        return null;
    }

    private String extractRubydoc(IMember member, IProgressMonitor monitor) throws RubyModelException, IOException {
        if (member != null && member.getRubyScript() != null) {
            return RDocUtil.getHTMLDocumentation((IRubyElement)member);
        }
        return null;
    }
}

