/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class CompletionProposalLabelProvider {
    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        int flags = proposal.getFlags();
        switch (proposal.getKind()) {
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                descriptor = RubyElementImageProvider.getMethodImageDescriptor(flags);
                break;
            }
            case 9: {
                descriptor = RubyElementImageProvider.getTypeImageDescriptor(false, false, false);
                break;
            }
            case 2: {
                descriptor = RubyElementImageProvider.getConstantImageDescriptor();
                break;
            }
            case 1: {
                descriptor = RubyElementImageProvider.getGlobalVariableImageDescriptor();
                break;
            }
            case 4: {
                descriptor = RubyElementImageProvider.getInstanceVariableImageDescriptor();
                break;
            }
            case 8: {
                descriptor = RubyElementImageProvider.getClassVariableImageDescriptor();
                break;
            }
            case 5: 
            case 10: {
                descriptor = RubyPluginImages.DESC_OBJS_LOCAL_VAR;
                break;
            }
            case 3: {
                descriptor = null;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        int adornments = 0;
        int flags = proposal.getFlags();
        int kind = proposal.getKind();
        if ((kind == 2 || kind == 7 || kind == 7 || kind == 12 || kind == 6) && Flags.isStatic((int)flags)) {
            adornments |= 8;
        }
        return new RubyElementImageDescriptor(descriptor, adornments, RubyElementImageProvider.SMALL_SIZE);
    }

    public String createLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: {
                return this.createMethodProposalLabel(proposal);
            }
            case 9: {
                return this.createTypeProposalLabel(proposal);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 3: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    String createTypeProposalLabel(CompletionProposal typeProposal) {
        return typeProposal.getType();
    }

    String createMethodProposalLabel(CompletionProposal methodProposal) {
        StringBuffer nameBuffer = new StringBuffer();
        nameBuffer.append(methodProposal.getName());
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(RubyElementLabels.CONCAT_STRING);
        String declaringType = methodProposal.getDeclaringType();
        nameBuffer.append(declaringType);
        return nameBuffer.toString();
    }

    private final StringBuffer appendUnboundedParameterList(StringBuffer buffer, CompletionProposal methodProposal) {
        String[] names = methodProposal.getParameterNames();
        if (names == null) {
            return buffer;
        }
        if (names.length > 0) {
            buffer.append('(');
        }
        int i = 0;
        while (i < names.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(names[i]);
            ++i;
        }
        if (names.length > 0) {
            buffer.append(')');
        }
        return buffer;
    }

    String createSimpleLabel(CompletionProposal proposal) {
        return String.valueOf(proposal.getCompletion());
    }

    String createSimpleLabelWithType(CompletionProposal proposal) {
        StringBuffer buf = new StringBuffer();
        buf.append(proposal.getCompletion());
        String typeName = proposal.getType();
        if (typeName.length() > 0) {
            buf.append("    ");
            buf.append(typeName);
        }
        return buf.toString();
    }

    public String createParameterList(CompletionProposal methodProposal) {
        Assert.isTrue((methodProposal.getKind() == 6 ? 1 : 0) != 0);
        return this.appendUnboundedParameterList(new StringBuffer(), methodProposal).toString();
    }
}

