/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderDescriptor;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;

public class RubyFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new RubyFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (RubyFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IRubyFoldingStructureProvider getCurrentFoldingProvider() {
        String id = RubyPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        RubyFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(id);
        if (desc != null) {
            try {
                return desc.createProvider();
            }
            catch (CoreException e) {
                RubyPlugin.log(e);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, RubyFoldingStructureProviderDescriptor> map = new HashMap<String, RubyFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(RubyPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            RubyFoldingStructureProviderDescriptor desc = new RubyFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

