/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RDocUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProviderExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRubyFoldingStructureProvider
implements IProjectionListener,
IRubyFoldingStructureProvider,
IRubyFoldingStructureProviderExtension {
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private IDocument fCachedDocument;
    private ProjectionAnnotationModel fCachedModel;
    private boolean fAllowCollapsing;
    private IRubyElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fCollapseInnerTypes;
    private boolean fCollapseRubydoc;
    private boolean fCollapseMethods;
    private final Filter fMemberFilter = new Filter(){

        public boolean match(RubyProjectionAnnotation annotation) {
            IRubyElement element;
            return !annotation.isCollapsed() && !annotation.isComment() && !annotation.isMarkedDeleted() && (element = annotation.getElement()) instanceof IMember && (element.getElementType() != 5 || ((IMember)element).getDeclaringType() != null);
        }
    };
    private final Filter fCommentFilter = new Filter(){

        public boolean match(RubyProjectionAnnotation annotation) {
            return !annotation.isCollapsed() && annotation.isComment() && !annotation.isMarkedDeleted();
        }
    };

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof RubyAbstractEditor) {
            this.fEditor = editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    @Override
    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        block12: {
            if (!this.isInstalled()) {
                return;
            }
            this.initializePreferences();
            try {
                ProjectionAnnotationModel model;
                IDocumentProvider provider = this.fEditor.getDocumentProvider();
                this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
                this.fAllowCollapsing = true;
                if (this.fEditor instanceof RubyEditor) {
                    WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
                    this.fInput = manager.getWorkingCopy(this.fEditor.getEditorInput());
                }
                if (this.fInput == null || (model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class)) == null) break block12;
                this.fCachedModel = model;
                if (this.fInput instanceof IRubyScript) {
                    IRubyScript unit;
                    IRubyScript iRubyScript = unit = (IRubyScript)this.fInput;
                    synchronized (iRubyScript) {
                        try {
                            unit.reconcile();
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                }
                Map<RubyProjectionAnnotation, Position> additions = this.computeAdditions((IParent)this.fInput);
                LinkedList removals = new LinkedList();
                Iterator existing = model.getAnnotationIterator();
                while (existing.hasNext()) {
                    removals.add(existing.next());
                }
                model.replaceAnnotations(removals.toArray(new Annotation[removals.size()]), additions);
            }
            finally {
                this.fCachedDocument = null;
                this.fAllowCollapsing = false;
                this.fCachedModel = null;
            }
        }
    }

    private Map<RubyProjectionAnnotation, Position> computeAdditions(IParent parent) {
        HashMap<RubyProjectionAnnotation, Position> map = new HashMap<RubyProjectionAnnotation, Position>();
        try {
            this.computeAdditions(parent.getChildren(), map);
        }
        catch (RubyModelException x) {
            RubyPlugin.log(x);
        }
        return map;
    }

    private void computeAdditions(IRubyElement[] elements, Map<RubyProjectionAnnotation, Position> map) throws RubyModelException {
        int i = 0;
        while (i < elements.length) {
            IRubyElement element = elements[i];
            this.computeAdditions(element, map);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeAdditions(parent.getChildren(), map);
            }
            ++i;
        }
    }

    private void computeAdditions(IRubyElement element, Map<RubyProjectionAnnotation, Position> map) {
        IRegion[] regions;
        boolean createProjection = false;
        boolean collapse = false;
        switch (element.getElementType()) {
            case 5: {
                collapse = this.fAllowCollapsing && this.fCollapseInnerTypes && this.isInnerType((IType)element);
                createProjection = true;
                break;
            }
            case 6: {
                collapse = this.fAllowCollapsing && this.fCollapseMethods;
                createProjection = true;
                break;
            }
            case 13: {
                collapse = false;
                createProjection = true;
            }
        }
        if (createProjection && (regions = this.computeProjectionRanges(element)) != null) {
            int i = 0;
            while (i < regions.length - 1) {
                Position position = this.createProjectionPosition(regions[i]);
                if (position != null) {
                    map.put(new RubyProjectionAnnotation(element, this.fAllowCollapsing && this.fCollapseRubydoc, true), position);
                }
                ++i;
            }
            Position position = this.createProjectionPosition(regions[regions.length - 1]);
            if (position != null) {
                map.put(new RubyProjectionAnnotation(element, collapse, false), position);
            }
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = store.getBoolean("editor_folding_default_innertypes");
        this.fCollapseRubydoc = store.getBoolean("editor_folding_default_rdoc");
        this.fCollapseMethods = store.getBoolean("editor_folding_default_methods");
    }

    private boolean isInnerType(IType type) {
        IRubyElement parent = type.getParent();
        if (parent != null) {
            int parentType = parent.getElementType();
            return parentType != 4;
        }
        return false;
    }

    private IRegion[] computeProjectionRanges(IRubyElement element) {
        block6: {
            int shift;
            ISourceRange range;
            block7: {
                try {
                    if (!(element instanceof ISourceReference)) break block6;
                    ISourceReference reference = (ISourceReference)element;
                    range = reference.getSourceRange();
                    String contents = reference.getSource();
                    if (contents != null) break block7;
                    return null;
                }
                catch (RubyModelException rubyModelException) {}
            }
            ArrayList<Object> regions = new ArrayList<Object>();
            int start = shift = range.getOffset();
            IRegion region = null;
            if (element instanceof IMember) {
                region = RDocUtil.getDocumentationRegion((IMember)element);
            }
            if (region != null) {
                regions.add(region);
            }
            regions.add(new Region(start, range.getOffset() + range.getLength() - start));
            if (regions.size() > 0) {
                IRegion[] result = new IRegion[regions.size()];
                regions.toArray(result);
                return result;
            }
        }
        return null;
    }

    private Position createProjectionPosition(IRegion region) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int start = this.fCachedDocument.getLineOfOffset(region.getOffset());
            int end = this.fCachedDocument.getLineOfOffset(region.getOffset() + region.getLength());
            if (start != end) {
                int offset = this.fCachedDocument.getLineOffset(start);
                int endOffset = -1;
                endOffset = end + 1 == this.fCachedDocument.getNumberOfLines() ? this.fCachedDocument.getLength() : this.fCachedDocument.getLineOffset(end + 1);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof RubyAbstractEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            RubyCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fElementListener != null) {
            RubyCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    protected void processDelta(IRubyElementDelta delta) {
        if (!this.isInstalled()) {
            return;
        }
        if ((delta.getFlags() & 9) == 0) {
            return;
        }
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (model == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fCachedModel = model;
            this.fAllowCollapsing = false;
            HashMap<RubyProjectionAnnotation, Position> additions = new HashMap<RubyProjectionAnnotation, Position>();
            ArrayList<RubyProjectionAnnotation> deletions = new ArrayList<RubyProjectionAnnotation>();
            ArrayList<RubyProjectionAnnotation> updates = new ArrayList<RubyProjectionAnnotation>();
            Map<RubyProjectionAnnotation, Position> updated = this.computeAdditions((IParent)this.fInput);
            Map previous = this.createAnnotationMap((IAnnotationModel)model);
            for (RubyProjectionAnnotation newAnnotation : updated.keySet()) {
                IRubyElement element = newAnnotation.getElement();
                Position newPosition = updated.get((Object)newAnnotation);
                List annotations = (List)previous.get(element);
                if (annotations == null) {
                    additions.put(newAnnotation, newPosition);
                    continue;
                }
                Iterator x = annotations.iterator();
                boolean matched = false;
                while (x.hasNext()) {
                    Tuple tuple = (Tuple)x.next();
                    RubyProjectionAnnotation existingAnnotation = tuple.annotation;
                    Position existingPosition = tuple.position;
                    if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                    if (existingPosition != null && !newPosition.equals((Object)existingPosition)) {
                        existingPosition.setOffset(newPosition.getOffset());
                        existingPosition.setLength(newPosition.getLength());
                        updates.add(existingAnnotation);
                    }
                    matched = true;
                    x.remove();
                    break;
                }
                if (!matched) {
                    additions.put(newAnnotation, newPosition);
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            for (List list : previous.values()) {
                int size = list.size();
                int i = 0;
                while (i < size) {
                    deletions.add(((Tuple)list.get((int)i)).annotation);
                    ++i;
                }
            }
            this.match(deletions, additions, updates);
            Annotation[] removals = new Annotation[deletions.size()];
            deletions.toArray(removals);
            Annotation[] changes = new Annotation[updates.size()];
            updates.toArray(changes);
            model.modifyAnnotations(removals, additions, changes);
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
            this.fCachedModel = null;
        }
    }

    private Map createAnnotationMap(IAnnotationModel model) {
        HashMap<IRubyElement, ArrayList<Tuple>> map = new HashMap<IRubyElement, ArrayList<Tuple>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof RubyProjectionAnnotation)) continue;
            RubyProjectionAnnotation ruby = (RubyProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)ruby);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(ruby.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(ruby.getElement(), list);
            }
            list.add(new Tuple(ruby, position));
        }
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tuple)o1).position.getOffset() - ((Tuple)o2).position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    private void match(List deletions, Map additions, List changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<RubyProjectionAnnotation> newDeletions = new ArrayList<RubyProjectionAnnotation>();
        ArrayList<RubyProjectionAnnotation> newChanges = new ArrayList<RubyProjectionAnnotation>();
        Iterator deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            RubyProjectionAnnotation deleted = (RubyProjectionAnnotation)((Object)deletionIterator.next());
            Position deletedPosition = this.fCachedModel.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions);
                addToDeletions = false;
            }
            if (match == null) continue;
            IRubyElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof RubyElementPosition && element instanceof IMember) {
                RubyElementPosition jep = (RubyElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection annotations, Map positionMap) {
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            RubyProjectionAnnotation annotation = (RubyProjectionAnnotation)((Object)it.next());
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? this.fCachedModel.getPosition((Annotation)annotation) : (Position)positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    @Override
    public void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    @Override
    public void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    @Override
    public void collapseElements(IRubyElement[] elements) {
        HashSet set = new HashSet(Arrays.asList(elements));
        this.modifyFiltered(new RubyElementSetFilter(set, false), false);
    }

    @Override
    public void expandElements(IRubyElement[] elements) {
        HashSet set = new HashSet(Arrays.asList(elements));
        this.modifyFiltered(new RubyElementSetFilter(set, true), true);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (model == null) {
            return;
        }
        ArrayList<RubyProjectionAnnotation> modified = new ArrayList<RubyProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            RubyProjectionAnnotation ruby;
            Object annotation = iter.next();
            if (!(annotation instanceof RubyProjectionAnnotation) || !filter.match(ruby = (RubyProjectionAnnotation)((Object)annotation))) continue;
            if (expand) {
                ruby.markExpanded();
            } else {
                ruby.markCollapsed();
            }
            modified.add(ruby);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IRubyElementDelta delta = this.findElement(DefaultRubyFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null) {
                if (delta.getRubyScriptAST() == null) {
                    return;
                }
                DefaultRubyFoldingStructureProvider.this.processDelta(delta);
            }
        }

        private IRubyElementDelta findElement(IRubyElement target, IRubyElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IRubyElement element = delta.getElement();
            if (element.getElementType() > 4) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IRubyElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IRubyElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(RubyProjectionAnnotation var1);
    }

    private static final class RubyElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public RubyElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (RubyModelException rubyModelException) {}
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (RubyModelException rubyModelException) {}
            return nameStart - this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RubyElementSetFilter
    implements Filter {
        private final Set<IRubyElement> fSet;
        private final boolean fMatchCollapsed;

        private RubyElementSetFilter(Set<IRubyElement> set, boolean matchCollapsed) {
            this.fSet = set;
            this.fMatchCollapsed = matchCollapsed;
        }

        @Override
        public boolean match(RubyProjectionAnnotation annotation) {
            IRubyElement element;
            boolean stateMatch;
            boolean bl = stateMatch = this.fMatchCollapsed == annotation.isCollapsed();
            return stateMatch && !annotation.isComment() && !annotation.isMarkedDeleted() && this.fSet.contains(element = annotation.getElement());
        }
    }

    private static class RubyProjectionAnnotation
    extends ProjectionAnnotation {
        private IRubyElement fRubyElement;
        private boolean fIsComment;

        public RubyProjectionAnnotation(IRubyElement element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fRubyElement = element;
            this.fIsComment = isComment;
        }

        public IRubyElement getElement() {
            return this.fRubyElement;
        }

        public void setElement(IRubyElement element) {
            this.fRubyElement = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }
    }

    private static final class Tuple {
        RubyProjectionAnnotation annotation;
        Position position;

        Tuple(RubyProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

