/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.text.correction.AssistContext;
import org.rubypeople.rdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.rubypeople.rdt.internal.ui.text.correction.CorrectionMessages;
import org.rubypeople.rdt.internal.ui.text.correction.IStatusLineProposal;
import org.rubypeople.rdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.rubypeople.rdt.internal.ui.text.correction.ProblemLocation;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionAssistant;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.correction.ChangeCorrectionProposal;
import org.rubypeople.rdt.ui.text.ruby.CompletionProposalComparator;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IQuickAssistProcessor;
import org.rubypeople.rdt.ui.text.ruby.IQuickFixProcessor;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class RubyCorrectionProcessor
implements org.eclipse.jface.text.quickassist.IQuickAssistProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fContributedAssistProcessors = null;
    private static ContributedProcessorDescriptor[] fContributedCorrectionProcessors = null;
    private RubyCorrectionAssistant fAssistant;
    private String fErrorMessage;

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String contributionId, boolean testMarkerTypes) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.rubypeople.rdt.ui", contributionId);
        ArrayList<ContributedProcessorDescriptor> res = new ArrayList<ContributedProcessorDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ContributedProcessorDescriptor desc = new ContributedProcessorDescriptor(elements[i], testMarkerTypes);
            IStatus status = desc.checkSyntax();
            if (status.isOK()) {
                res.add(desc);
            } else {
                RubyPlugin.log(status);
            }
            ++i;
        }
        return res.toArray(new ContributedProcessorDescriptor[res.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fContributedCorrectionProcessors == null) {
            fContributedCorrectionProcessors = RubyCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID, true);
        }
        return fContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fContributedAssistProcessors == null) {
            fContributedAssistProcessors = RubyCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID, false);
        }
        return fContributedAssistProcessors;
    }

    public static boolean hasCorrections(IRubyScript cu, int problemId, String markerType) {
        ContributedProcessorDescriptor[] processors = RubyCorrectionProcessor.getCorrectionProcessors();
        SafeHasCorrections collector = new SafeHasCorrections(cu, problemId);
        int i = 0;
        while (i < processors.length) {
            if (processors[i].canHandleMarkerType(markerType)) {
                collector.process(processors[i]);
                if (collector.hasCorrections()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IRubyAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        IRubyScript cu;
        IRubyAnnotation javaAnnotation;
        int problemId;
        if (annotation instanceof IRubyAnnotation && (problemId = (javaAnnotation = (IRubyAnnotation)annotation).getId()) != -1 && (cu = javaAnnotation.getRubyScript()) != null) {
            return RubyCorrectionProcessor.hasCorrections(cu, problemId, javaAnnotation.getMarkerType());
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return RubyCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(IInvocationContext context) {
        ContributedProcessorDescriptor[] processors = RubyCorrectionProcessor.getAssistProcessors();
        SafeHasAssist collector = new SafeHasAssist(context);
        int i = 0;
        while (i < processors.length) {
            collector.process(processors[i]);
            if (collector.hasAssists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RubyCorrectionProcessor(RubyCorrectionAssistant assistant) {
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                RubyCorrectionProcessor.this.fAssistant.setStatusLineVisible(false);
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                RubyCorrectionProcessor.this.fAssistant.setStatusLineVisible(true);
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                if (proposal instanceof IStatusLineProposal) {
                    IStatusLineProposal statusLineProposal = (IStatusLineProposal)proposal;
                    String message = statusLineProposal.getStatusMessage();
                    if (message != null) {
                        RubyCorrectionProcessor.this.fAssistant.setStatusMessage(message);
                    } else {
                        RubyCorrectionProcessor.this.fAssistant.setStatusMessage("");
                    }
                } else {
                    RubyCorrectionProcessor.this.fAssistant.setStatusMessage("");
                }
            }
        });
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int documentOffset = quickAssistContext.getOffset();
        IEditorPart part = this.fAssistant.getEditor();
        IRubyScript cu = RubyUI.getWorkingCopyManager().getWorkingCopy(part.getEditorInput());
        IAnnotationModel model = RubyUI.getDocumentProvider().getAnnotationModel((Object)part.getEditorInput());
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        AssistContext context = new AssistContext(cu, documentOffset, length);
        Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
        this.fErrorMessage = null;
        ICompletionProposal[] res = null;
        if (model != null && annotations != null) {
            ArrayList proposals = new ArrayList(10);
            IStatus status = RubyCorrectionProcessor.collectProposals(context, model, annotations, true, !this.fAssistant.isUpdatedOffset(), proposals);
            res = proposals.toArray(new ICompletionProposal[proposals.size()]);
            if (!status.isOK()) {
                this.fErrorMessage = status.getMessage();
                RubyPlugin.log(status);
            }
        }
        if (res == null || res.length == 0) {
            return new ICompletionProposal[]{new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (res.length > 1) {
            Arrays.sort(res, new CompletionProposalComparator());
        }
        return res;
    }

    public static IStatus collectProposals(IInvocationContext context, IAnnotationModel model, Annotation[] annotations, boolean addQuickFixes, boolean addQuickAssists, Collection proposals) {
        IStatus status;
        ArrayList<ProblemLocation> problems = new ArrayList<ProblemLocation>();
        int i = 0;
        while (i < annotations.length) {
            Annotation curr = annotations[i];
            if (curr instanceof IRubyAnnotation) {
                ProblemLocation problemLocation = RubyCorrectionProcessor.getProblemLocation((IRubyAnnotation)curr, model);
                if (problemLocation != null) {
                    problems.add(problemLocation);
                }
            } else if (addQuickFixes && curr instanceof SimpleMarkerAnnotation) {
                RubyCorrectionProcessor.collectMarkerProposals((SimpleMarkerAnnotation)curr, proposals);
            }
            ++i;
        }
        MultiStatus resStatus = null;
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        if (addQuickFixes && !(status = RubyCorrectionProcessor.collectCorrections(context, problemLocations, proposals)).isOK()) {
            resStatus = new MultiStatus("org.rubypeople.rdt.ui", 4, CorrectionMessages.RubyCorrectionProcessor_error_quickfix_message, null);
            resStatus.add(status);
        }
        if (addQuickAssists && !(status = RubyCorrectionProcessor.collectAssists(context, problemLocations, proposals)).isOK()) {
            if (resStatus == null) {
                resStatus = new MultiStatus("org.rubypeople.rdt.ui", 4, CorrectionMessages.RubyCorrectionProcessor_error_quickassist_message, null);
            }
            resStatus.add(status);
        }
        if (resStatus != null) {
            return resStatus;
        }
        return Status.OK_STATUS;
    }

    private static ProblemLocation getProblemLocation(IRubyAnnotation javaAnnotation, IAnnotationModel model) {
        Position pos;
        int problemId = javaAnnotation.getId();
        if (problemId != -1 && (pos = model.getPosition((Annotation)javaAnnotation)) != null) {
            return new ProblemLocation(pos.getOffset(), pos.getLength(), javaAnnotation);
        }
        return null;
    }

    private static void collectMarkerProposals(SimpleMarkerAnnotation annotation, Collection proposals) {
        IMarker marker = annotation.getMarker();
        IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
        if (res.length > 0) {
            int i = 0;
            while (i < res.length) {
                proposals.add(new MarkerResolutionProposal(res[i], marker));
                ++i;
            }
        }
    }

    public static IStatus collectCorrections(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
        ContributedProcessorDescriptor[] processors = RubyCorrectionProcessor.getCorrectionProcessors();
        SafeCorrectionCollector collector = new SafeCorrectionCollector(context, proposals);
        int i = 0;
        while (i < processors.length) {
            ContributedProcessorDescriptor curr = processors[i];
            IProblemLocation[] handled = RubyCorrectionProcessor.getHandledProblems(locations, curr);
            if (handled != null) {
                collector.setProblemLocations(handled);
                collector.process(curr);
            }
            ++i;
        }
        return collector.getStatus();
    }

    private static IProblemLocation[] getHandledProblems(IProblemLocation[] locations, ContributedProcessorDescriptor processor) {
        boolean allHandled = true;
        ArrayList<IProblemLocation> res = null;
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            if (processor.canHandleMarkerType(curr.getMarkerType())) {
                if (!allHandled) {
                    if (res == null) {
                        res = new ArrayList<IProblemLocation>(locations.length - i);
                    }
                    res.add(curr);
                }
            } else if (allHandled) {
                if (i > 0) {
                    res = new ArrayList(locations.length - i);
                    int k = 0;
                    while (k < i) {
                        res.add(locations[k]);
                        ++k;
                    }
                }
                allHandled = false;
            }
            ++i;
        }
        if (allHandled) {
            return locations;
        }
        if (res == null) {
            return null;
        }
        return res.toArray(new IProblemLocation[res.size()]);
    }

    public static IStatus collectAssists(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
        ContributedProcessorDescriptor[] processors = RubyCorrectionProcessor.getAssistProcessors();
        SafeAssistCollector collector = new SafeAssistCollector(context, locations, proposals);
        collector.process(processors);
        return collector.getStatus();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return RubyCorrectionProcessor.hasCorrections(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        if (invocationContext instanceof IInvocationContext) {
            return RubyCorrectionProcessor.hasAssists((IInvocationContext)invocationContext);
        }
        return false;
    }

    private static class SafeAssistCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final IProblemLocation[] fLocations;
        private final Collection fProposals;

        public SafeAssistCollector(IInvocationContext context, IProblemLocation[] locations, Collection proposals) {
            this.fContext = context;
            this.fLocations = locations;
            this.fProposals = proposals;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IRubyCompletionProposal[] res;
            IQuickAssistProcessor curr = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getRubyScript());
            if (curr != null && (res = curr.getAssists(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    private static class SafeCorrectionCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final Collection fProposals;
        private IProblemLocation[] fLocations;

        public SafeCorrectionCollector(IInvocationContext context, Collection proposals) {
            this.fContext = context;
            this.fProposals = proposals;
        }

        public void setProblemLocations(IProblemLocation[] locations) {
            this.fLocations = locations;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IRubyCompletionProposal[] res;
            IQuickFixProcessor curr = (IQuickFixProcessor)desc.getProcessor(this.fContext.getRubyScript());
            if (curr != null && (res = curr.getCorrections(this.fContext, this.fLocations)) != null) {
                int k = 0;
                while (k < res.length) {
                    this.fProposals.add(res[k]);
                    ++k;
                }
            }
        }
    }

    private static abstract class SafeCorrectionProcessorAccess
    implements ISafeRunnable {
        private MultiStatus fMulti = null;
        private ContributedProcessorDescriptor fDescriptor;

        private SafeCorrectionProcessorAccess() {
        }

        public void process(ContributedProcessorDescriptor[] desc) {
            int i = 0;
            while (i < desc.length) {
                this.fDescriptor = desc[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
        }

        public void process(ContributedProcessorDescriptor desc) {
            this.fDescriptor = desc;
            SafeRunner.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.safeRun(this.fDescriptor);
        }

        protected abstract void safeRun(ContributedProcessorDescriptor var1) throws Exception;

        public void handleException(Throwable exception) {
            if (this.fMulti == null) {
                this.fMulti = new MultiStatus("org.rubypeople.rdt.ui", 0, CorrectionMessages.RubyCorrectionProcessor_error_status, null);
            }
            this.fMulti.merge((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, CorrectionMessages.RubyCorrectionProcessor_error_status, exception));
        }

        public IStatus getStatus() {
            if (this.fMulti == null) {
                return Status.OK_STATUS;
            }
            return this.fMulti;
        }
    }

    private static class SafeHasAssist
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private boolean fHasAssists;

        public SafeHasAssist(IInvocationContext context) {
            this.fContext = context;
            this.fHasAssists = false;
        }

        public boolean hasAssists() {
            return this.fHasAssists;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickAssistProcessor processor = (IQuickAssistProcessor)desc.getProcessor(this.fContext.getRubyScript());
            if (processor != null && processor.hasAssists(this.fContext)) {
                this.fHasAssists = true;
            }
        }
    }

    private static class SafeHasCorrections
    extends SafeCorrectionProcessorAccess {
        private final IRubyScript fCu;
        private final int fProblemId;
        private boolean fHasCorrections;

        public SafeHasCorrections(IRubyScript cu, int problemId) {
            this.fCu = cu;
            this.fProblemId = problemId;
            this.fHasCorrections = false;
        }

        public boolean hasCorrections() {
            return this.fHasCorrections;
        }

        public void safeRun(ContributedProcessorDescriptor desc) throws Exception {
            IQuickFixProcessor processor = (IQuickFixProcessor)desc.getProcessor(this.fCu);
            if (processor != null && processor.hasCorrections(this.fCu, this.fProblemId)) {
                this.fHasCorrections = true;
            }
        }
    }
}

