/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;

public class ProblemLocation
implements IProblemLocation {
    private final int fId;
    private final String[] fArguments;
    private final int fOffset;
    private final int fLength;
    private final boolean fIsError;
    private final String fMarkerType;

    public ProblemLocation(int offset, int length, IRubyAnnotation annotation) {
        this.fId = annotation.getId();
        this.fArguments = annotation.getArguments();
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = "org.rubypeople.rdt.ui.error".equals(annotation.getType());
        String markerType = annotation.getMarkerType();
        this.fMarkerType = markerType != null ? markerType : "org.rubypeople.rdt.core.problem";
    }

    public ProblemLocation(int offset, int length, int id, String[] arguments, boolean isError, String markerType) {
        this.fId = id;
        this.fArguments = arguments;
        this.fOffset = offset;
        this.fLength = length;
        this.fIsError = isError;
        this.fMarkerType = markerType;
    }

    public ProblemLocation(IProblem problem) {
        this.fId = problem.getID();
        this.fArguments = problem.getArguments();
        this.fOffset = problem.getSourceStart();
        this.fLength = problem.getSourceEnd() - this.fOffset + 1;
        this.fIsError = problem.isError();
        this.fMarkerType = problem instanceof CategorizedProblem ? ((CategorizedProblem)problem).getMarkerType() : "org.rubypeople.rdt.core.problem";
    }

    public int getProblemId() {
        return this.fId;
    }

    public String[] getProblemArguments() {
        return this.fArguments;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public boolean isError() {
        return this.fIsError;
    }

    public String getMarkerType() {
        return this.fMarkerType;
    }

    public Node getCoveringNode(RootNode astRoot) {
        return ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)astRoot, this.fOffset - 1, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node.getPosition().getEndOffset() >= ProblemLocation.this.fOffset + ProblemLocation.this.fLength;
            }
        });
    }

    public Node getCoveredNode(RootNode astRoot) {
        return ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)astRoot, this.fOffset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node.getPosition().getEndOffset() >= ProblemLocation.this.fOffset + ProblemLocation.this.fLength;
            }
        });
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Id: ").append(this.getErrorCode(this.fId)).append('\n');
        buf.append('[').append(this.fOffset).append(", ").append(this.fLength).append(']').append('\n');
        return buf.toString();
    }

    private String getErrorCode(int code) {
        StringBuffer buf = new StringBuffer();
        if ((code & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((code & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((code & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((code & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((code & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((code & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((code & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        buf.append(code & 0xFFFFFF);
        return buf.toString();
    }
}

