/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.text.correction.CorrectionMessages;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class MarkerResolutionProposal
implements IRubyCompletionProposal {
    private IMarkerResolution fResolution;
    private IMarker fMarker;

    public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
        this.fResolution = resolution;
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        this.fResolution.run(this.fMarker);
    }

    public String getAdditionalProposalInfo() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getDescription();
        }
        try {
            String problemDesc = (String)this.fMarker.getAttribute("message");
            return Messages.format((String)CorrectionMessages.MarkerResolutionProposal_additionaldesc, (String)problemDesc);
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
            return null;
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fResolution.getLabel();
    }

    public Image getImage() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getImage();
        }
        return RubyPluginImages.get("org.rubypeople.rdt.ui.correction_change.gif");
    }

    public int getRelevance() {
        return 10;
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

