/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IFileEditorInput;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.core.parser.MarkerUtility;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class IgnoreWarningProposal
implements IRubyCompletionProposal {
    private IProblemLocation problem;
    private IInvocationContext context;

    public IgnoreWarningProposal(IInvocationContext context, IProblemLocation problem) {
        this.context = context;
        this.problem = problem;
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        try {
            IRubyScript script = this.context.getRubyScript();
            IFileEditorInput editorInput = (IFileEditorInput)EditorUtility.getEditorInput(script);
            IAnnotationModel anoteModel = RubyPlugin.getDefault().getRubyDocumentProvider().getAnnotationModel(editorInput);
            Iterator iter = anoteModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                IRubyAnnotation markerAnote;
                Annotation anote = (Annotation)iter.next();
                if (!(anote instanceof IRubyAnnotation) || (markerAnote = (IRubyAnnotation)anote).getId() != this.problem.getProblemId() || (pos = anoteModel.getPosition(anote)).getOffset() != this.problem.getOffset() || pos.getLength() != this.problem.getLength()) continue;
                anoteModel.removeAnnotation(anote);
                MarkerUtility.ignore((IResource)script.getResource(), (int)this.problem.getProblemId(), (int)this.problem.getOffset(), (int)this.problem.getLength());
            }
            IResource resource = script.getUnderlyingResource();
            IMarker[] markers = resource.findMarkers(this.problem.getMarkerType(), true, 0);
            boolean needToRebuild = false;
            int i = 0;
            while (i < markers.length) {
                if (MarkerUtility.markerMatches((int)this.problem.getProblemId(), (int)this.problem.getOffset(), (int)(this.problem.getOffset() + this.problem.getLength()), (IMarker)markers[i])) {
                    MarkerUtility.ignore((IMarker)markers[i]);
                    needToRebuild = true;
                }
                ++i;
            }
            if (needToRebuild) {
                resource.touch((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
        }
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Ignore this warning";
    }

    public Image getImage() {
        return RubyPluginImages.get("org.rubypeople.rdt.ui.lightbulb.png");
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

