/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.internal.ui.text.correction.CUCorrectionProposal;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;

public class HashSyntaxCorrectionProposal
extends CUCorrectionProposal {
    private static final String NAME = "Fix Hash Syntax";
    private IInvocationContext context;
    private IProblemLocation problem;

    public HashSyntaxCorrectionProposal(IInvocationContext context, IProblemLocation problem, int relevance) {
        super(NAME, context.getRubyScript(), relevance, RubyUI.getSharedImages().getImage("org.rubypeople.rdt.ui.correction_change.gif"));
        this.context = context;
        this.problem = problem;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        String src = this.getRubyScript().getSource();
        ArrayNode covering = (ArrayNode)this.problem.getCoveringNode(this.context.getASTRoot());
        List children = covering.childNodes();
        int i = 0;
        while (i < children.size()) {
            Node value;
            if (children.size() <= 2) break;
            Node key = (Node)children.get(i);
            if (key != null && (value = (Node)children.get(i + 1)) != null) {
                ISourcePosition pos = key.getPosition();
                String between = src.substring(pos.getEndOffset(), value.getPosition().getStartOffset());
                String corrected = "";
                if (!between.startsWith(" ")) {
                    corrected = String.valueOf(corrected) + " ";
                }
                corrected = String.valueOf(corrected) + "=>";
                if (!between.endsWith(" ")) {
                    corrected = String.valueOf(corrected) + " ";
                }
                ReplaceEdit edit = new ReplaceEdit(pos.getEndOffset() + between.indexOf(","), 1, corrected);
                editRoot.addChild((TextEdit)edit);
            }
            i += 2;
        }
    }
}

