/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;

public class AssistContext
implements IInvocationContext {
    private IRubyScript fRubyScript;
    private int fOffset;
    private int fLength;
    private RootNode fASTRoot;

    public AssistContext(IRubyScript cu, int offset, int length) {
        this.fRubyScript = cu;
        this.fOffset = offset;
        this.fLength = length;
        this.fASTRoot = null;
    }

    public IRubyScript getRubyScript() {
        return this.fRubyScript;
    }

    public int getSelectionLength() {
        return this.fLength;
    }

    public int getSelectionOffset() {
        return this.fOffset;
    }

    public RootNode getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTProvider.getASTProvider().getAST((IRubyElement)this.fRubyScript, ASTProvider.WAIT_YES, null);
        }
        return this.fASTRoot;
    }

    public void setASTRoot(RootNode root) {
        this.fASTRoot = root;
    }

    public Node getCoveringNode() {
        return ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)this.getASTRoot(), this.fOffset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return true;
            }
        });
    }

    public Node getCoveredNode() {
        return OffsetNodeLocator.Instance().getNodeAtOffset((Node)this.getASTRoot(), this.fOffset);
    }
}

