/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.comment;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;

public class RubyCommentAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;
    private ITextEditor fEditor;
    private WorkingCopyManager fManager;
    private IRubyProject fProject;

    public RubyCommentAutoIndentStrategy(ITextEditor textEditor, String partitioning, IRubyProject project) {
        this.fPartitioning = partitioning;
        this.fEditor = textEditor;
        this.fManager = RubyPlugin.getDefault().getWorkingCopyManager();
        this.fProject = project;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String[] lineDelimiters;
        int index;
        if (command.text != null && command.length == 0 && (index = TextUtilities.endsWith((String[])(lineDelimiters = document.getLegalLineDelimiters()), (String)command.text)) > -1) {
            if (lineDelimiters[index].equals(command.text)) {
                this.indentAfterNewLine(document, command);
            }
            return;
        }
    }

    private void indentAfterNewLine(IDocument d, DocumentCommand c) {
        if (this.fPartitioning.equals("__ruby_singleline_comment")) {
            this.doSingleLineComment(d, c);
        } else {
            this.doMultiLineComment(d, c);
        }
    }

    private void doMultiLineComment(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            try {
                new RubyParser().parse(d.get());
                return;
            }
            catch (SyntaxException se) {
                if (!se.getMessage().equals("embedded document meets end of file")) {
                    return;
                }
                int lineNumber = d.getLineOfOffset(p);
                d.getLineInformation(lineNumber);
                String aLine = this.getLine(d, lineNumber - 1);
                StringBuffer buf = new StringBuffer(c.text);
                if (aLine.trim().equals("=begin")) {
                    buf.append(CodeFormatterUtil.createIndentString(1, this.fProject));
                    c.caretOffset = c.offset + buf.length();
                    c.shiftsCaret = false;
                    buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                    buf.append("=end");
                }
                c.text = buf.toString();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void doSingleLineComment(IDocument d, DocumentCommand c) {
        int offset = c.offset;
        if (offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            String previousLine;
            String nextLine;
            int p = offset == d.getLength() ? offset - 1 : offset;
            int lineNumber = d.getLineOfOffset(p);
            IRegion line = d.getLineInformation(lineNumber);
            if (!(lineNumber == 0 || this.isComment(nextLine = this.getLine(d, lineNumber + 1)) || this.isClassDefinition(nextLine) || this.isMethodDeclaration(nextLine) || this.isAttributeCall(nextLine) || this.isAliasCall(nextLine) || this.isModuleDeclaration(nextLine) || this.isConstantAssignment(nextLine) || this.isComment(previousLine = this.getLine(d, lineNumber - 1)))) {
                return;
            }
            int lineOffset = line.getOffset();
            int firstNonWS = this.findEndOfWhiteSpace(d, lineOffset, offset);
            Assert.isTrue((firstNonWS >= lineOffset ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer buf = new StringBuffer(c.text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            String src = this.getRDoc(d, c.text, lineNumber + 1);
            if (src != null) {
                buf.append(src);
            }
            if (lengthToAdd < prefix.getLength()) {
                c.caretOffset = offset + prefix.getLength() - lengthToAdd;
            }
            c.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private String getRDoc(IDocument d, String newLine, int line) {
        IRubyElement element;
        block8: {
            int pos;
            IRubyScript script = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            try {
                IRegion region = d.getLineInformation(line);
                pos = this.findEndOfWhiteSpace(d, region.getOffset(), region.getOffset() + region.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return null;
            }
            element = null;
            element = script.getElementAt(pos);
            if (element != null) break block8;
            return null;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                String[] names = method.getParameterNames();
                int i = 0;
                while (i < names.length) {
                    String name = names[i];
                    int end = name.indexOf(32);
                    if (end != -1) {
                        name = name.substring(0, end);
                    }
                    buffer.append("+");
                    buffer.append(name);
                    buffer.append("+");
                    buffer.append(newLine);
                    ++i;
                }
            }
            return buffer.toString();
        }
        catch (RubyModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isComment(String nextLineText) {
        return nextLineText.matches("^\\s*#.*");
    }

    private boolean isClassDefinition(String nextLineText) {
        return nextLineText.matches("^\\s*class\\s+.+\\s*");
    }

    private boolean isAliasCall(String nextLineText) {
        return nextLineText.matches("^\\s*alias\\s+.+\\s*");
    }

    private boolean isModuleDeclaration(String nextLineText) {
        return nextLineText.matches("^\\s*module\\s+.+\\s*");
    }

    private boolean isMethodDeclaration(String nextLineText) {
        return nextLineText.matches("^\\s*def\\s+.+\\s*");
    }

    private boolean isAttributeCall(String nextLineText) {
        return nextLineText.matches("^\\s*attr.+\\s*");
    }

    private boolean isConstantAssignment(String nextLineText) {
        return nextLineText.matches("^\\s*[A-Z_]+\\s?=\\s+.+\\s*");
    }

    private String getLine(IDocument d, int lineNum) throws BadLocationException {
        IRegion nextLineRegion = d.getLineInformation(lineNum + 1);
        return d.get(nextLineRegion.getOffset(), nextLineRegion.getLength());
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '#') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }
}

