/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.comment;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.ToolFactory;
import org.rubypeople.rdt.core.formatter.CodeFormatter;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private int fLastDocumentHash;
    private int fLastHeaderHash;
    private int fLastMainTokenEnd = -1;
    private int fLastDocumentsHeaderEnd;

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition position = (TypedPosition)this.fPartitions.removeFirst();
        if (document == null || position == null) {
            return;
        }
        Map preferences = this.getPreferences();
        boolean isFormattingHeader = Boolean.toString(true).equals(preferences.get("org.rubypeople.rdt.core.formatter.comment.format_header"));
        int documentsHeaderEnd = this.computeHeaderEnd(document);
        if (isFormattingHeader || position.offset >= documentsHeaderEnd) {
            TextEdit edit = null;
            try {
                int sourceOffset = document.getLineOffset(document.getLineOfOffset(position.getOffset()));
                int partitionOffset = position.getOffset() - sourceOffset;
                int sourceLength = partitionOffset + position.getLength();
                String source = document.get(sourceOffset, sourceLength);
                CodeFormatter commentFormatter = ToolFactory.createCodeFormatter((Map)preferences);
                int indentationLevel = this.inferIndentationLevel(source.substring(0, partitionOffset), CommentFormattingStrategy.getTabSize(preferences));
                edit = commentFormatter.format(CommentFormattingStrategy.getKindForPartitionType(position.getType()), source, partitionOffset, position.getLength(), indentationLevel, TextUtilities.getDefaultLineDelimiter((IDocument)document));
                if (edit != null) {
                    edit.moveTree(sourceOffset);
                }
            }
            catch (BadLocationException x) {
                RubyPlugin.log(x);
            }
            try {
                if (edit != null) {
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException x) {
                RubyPlugin.log(x);
            }
            catch (BadLocationException x) {
                RubyPlugin.log(x);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        this.fPartitions.clear();
        this.fDocuments.clear();
        super.formatterStops();
    }

    private static int getKindForPartitionType(String type) {
        if ("__ruby_singleline_comment".equals(type)) {
            return 16;
        }
        if ("__ruby_multiline_comment".equals(type)) {
            return 32;
        }
        return 0;
    }

    private int inferIndentationLevel(String reference, int tabSize) {
        StringBuffer expanded = CommentFormattingStrategy.expandTabs(reference, tabSize);
        int referenceWidth = expanded.length();
        if (tabSize == 0) {
            return referenceWidth;
        }
        int spaceWidth = 1;
        int level = referenceWidth / (tabSize * spaceWidth);
        if (referenceWidth % (tabSize * spaceWidth) > 0) {
            ++level;
        }
        return level;
    }

    private static StringBuffer expandTabs(String string, int tabSize) {
        StringBuffer expanded = new StringBuffer();
        int i = 0;
        int n = string.length();
        int chars = 0;
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '\t') {
                while (chars < tabSize) {
                    expanded.append(' ');
                    ++chars;
                }
                chars = 0;
            } else {
                expanded.append(ch);
                if (++chars >= tabSize) {
                    chars = 0;
                }
            }
            ++i;
        }
        return expanded;
    }

    private static int getTabSize(Map preferences) {
        if (preferences.containsKey("org.rubypeople.rdt.core.formatter.tabulation.size")) {
            try {
                return Integer.parseInt((String)preferences.get("org.rubypeople.rdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private int computeHeaderEnd(IDocument document) {
        if (document == null) {
            return -1;
        }
        try {
            if (this.fLastMainTokenEnd >= 0 && document.hashCode() == this.fLastDocumentHash && this.fLastMainTokenEnd < document.getLength() && document.get(0, this.fLastMainTokenEnd).hashCode() == this.fLastHeaderHash) {
                return this.fLastDocumentsHeaderEnd;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }
}

