/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;

public class RubyElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private RubyEditor fEditor;
    private boolean fUseCodeResolve = false;

    public RubyElementProvider(IEditorPart editor) {
        if (editor instanceof RubyEditor) {
            this.fEditor = (RubyEditor)editor;
        }
    }

    public RubyElementProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = RubyWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection sel;
            if (this.fUseCodeResolve && !(sel = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return sel.getFirstElement();
            }
            IRubyElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                return element;
            }
            return EditorUtility.getEditorInputRubyElement((IEditorPart)this.fEditor, false);
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }
}

