/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.ui.IEditorPart;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.search.MatchFilter;
import org.rubypeople.rdt.internal.ui.search.RubyElementMatch;
import org.rubypeople.rdt.internal.ui.search.RubySearchQuery;
import org.rubypeople.rdt.ui.search.IMatchPresentation;

public class RubySearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private RubySearchQuery fQuery;
    private Map fElementsToParticipants;
    private static final Match[] NO_MATCHES = new Match[0];
    private MatchFilter[] fActivatedMatchFilters;

    public RubySearchResult(RubySearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap();
        this.fActivatedMatchFilters = MatchFilter.getLastUsedFilters();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void setActivatedFilters(MatchFilter[] matchFilters) {
        this.fActivatedMatchFilters = matchFilters;
        MatchFilter.setLastUsedFilters(matchFilters);
        this.updateFilterStateForAllMarkers();
        this.fireChange(new MatchFilterEvent((ISearchResult)this, matchFilters));
    }

    public MatchFilter[] getActivatedMatchFilters() {
        return this.fActivatedMatchFilters;
    }

    public boolean hasMatchFilterActivated(MatchFilter filter) {
        String id = filter.getID();
        int i = 0;
        while (i < this.fActivatedMatchFilters.length) {
            if (this.fActivatedMatchFilters[i].getID().equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void fireChange(SearchResultEvent e) {
        if (e instanceof MatchEvent && ((MatchEvent)e).getKind() == 1) {
            this.updateFilterState(((MatchEvent)e).getMatches());
        }
        super.fireChange(e);
    }

    private void updateFilterStateForAllMarkers() {
        Object[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            this.updateFilterState(this.getMatches(elements[i]));
            ++i;
        }
    }

    private void updateFilterState(Match[] matches) {
        int i = 0;
        while (i < matches.length) {
            Match match = matches[i];
            if (match instanceof RubyElementMatch) {
                this.updateFilterState((RubyElementMatch)match);
            }
            ++i;
        }
    }

    private void updateFilterState(RubyElementMatch match) {
        int i = 0;
        while (i < this.fActivatedMatchFilters.length) {
            if (this.fActivatedMatchFilters[i].filters(match)) {
                match.setFiltered(true);
                return;
            }
            ++i;
        }
        match.setFiltered(false);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IAdaptable)file);
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        IFile file;
        IRubyElement javaElement = (IRubyElement)adaptable.getAdapter(IRubyElement.class);
        HashSet matches = new HashSet();
        if (javaElement != null) {
            this.collectMatches(matches, javaElement);
        }
        if ((file = (IFile)adaptable.getAdapter(IFile.class)) != null) {
            this.collectMatches(matches, file);
        }
        if (!matches.isEmpty()) {
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set matches, IFile element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
    }

    private void collectMatches(Set matches, IRubyElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IRubyElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IRubyElement) {
            IRubyElement javaElement = (IRubyElement)element;
            IRubyScript cu = (IRubyScript)javaElement.getAncestor(4);
            if (cu != null) {
                return (IFile)cu.getResource();
            }
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IRubyElement) {
            return (element = ((IRubyElement)element).getOpenable()) != null && element.equals(editor.getEditorInput().getAdapter(IRubyElement.class));
        }
        if (element instanceof IFile) {
            return element.equals(editor.getEditorInput().getAdapter(IFile.class));
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object element) {
        return (IMatchPresentation)this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            RubyPlugin.log((IStatus)new Status(2, RubyPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        RubySearchResult rubySearchResult = this;
        synchronized (rubySearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        RubySearchResult rubySearchResult = this;
        synchronized (rubySearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public static class MatchFilterEvent
    extends SearchResultEvent {
        private static final long serialVersionUID = 1234L;
        private final MatchFilter[] fActivatedFilters;

        public MatchFilterEvent(ISearchResult searchResult, MatchFilter[] activatedFilters) {
            super(searchResult);
            this.fActivatedFilters = activatedFilters;
        }

        public MatchFilter[] getActivatedFilters() {
            return this.fActivatedFilters;
        }
    }
}

