/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.search.FieldReferenceMatch;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.ui.search.RubyElementMatch;
import org.rubypeople.rdt.internal.ui.search.RubySearchResult;

public class NewSearchResultCollector
extends SearchRequestor {
    private RubySearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(RubySearchResult search, boolean ignorePotentials) {
        this.fSearch = search;
        this.fIgnorePotentials = ignorePotentials;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IRubyElement enclosingElement = (IRubyElement)match.getElement();
        if (enclosingElement != null) {
            if (this.fIgnorePotentials && match.getAccuracy() == 1) {
                return;
            }
            boolean isWriteAccess = false;
            boolean isReadAccess = false;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                isWriteAccess = fieldRef.isWriteAccess();
                isReadAccess = fieldRef.isReadAccess();
            }
            this.fSearch.addMatch(new RubyElementMatch(enclosingElement, match.getRule(), match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment()));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }
}

