/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ASTProvider;
import org.rubypeople.rdt.internal.ui.search.IOccurrencesFinder;
import org.rubypeople.rdt.internal.ui.search.OccurrencesSearchQuery;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;

public abstract class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    protected FindOccurrencesEngine(IOccurrencesFinder finder) {
        this.fFinder = finder;
    }

    public static FindOccurrencesEngine create(IRubyElement root, IOccurrencesFinder finder) {
        if (root == null || finder == null) {
            return null;
        }
        IRubyScript unit = (IRubyScript)root.getAncestor(4);
        if (unit != null) {
            return new FindOccurencesCUEngine(unit, finder);
        }
        return null;
    }

    protected abstract Node createAST();

    protected abstract IRubyElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected IOccurrencesFinder getOccurrencesFinder() {
        return this.fFinder;
    }

    public String run(int offset, int length) throws RubyModelException {
        ISourceReference sr = this.getSourceReference();
        if (sr.getSourceRange() == null) {
            return SearchMessages.FindOccurrencesEngine_noSource_text;
        }
        Node root = this.createAST();
        if (root == null) {
            return SearchMessages.FindOccurrencesEngine_cannotParse_text;
        }
        String message = this.fFinder.initialize(root, offset, length);
        if (message != null) {
            return message;
        }
        this.fFinder.setFMarkConstantOccurrences(true);
        this.fFinder.setFMarkFieldOccurrences(true);
        this.fFinder.setFMarkLocalVariableOccurrences(true);
        this.fFinder.setFMarkTypeOccurrences(true);
        this.fFinder.setFMarkMethodOccurrences(true);
        Document document = new Document(this.getSourceReference().getSource());
        this.performNewSearch(this.fFinder, (IDocument)document, this.getInput());
        return null;
    }

    private void performNewSearch(IOccurrencesFinder finder, IDocument document, IRubyElement element) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(finder, document, element));
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private IRubyScript fScript;

        public FindOccurencesCUEngine(IRubyScript unit, IOccurrencesFinder finder) {
            super(finder);
            this.fScript = unit;
        }

        protected Node createAST() {
            return RubyPlugin.getDefault().getASTProvider().getAST((IRubyElement)this.fScript, ASTProvider.WAIT_YES, null);
        }

        protected IRubyElement getInput() {
            return this.fScript;
        }

        protected ISourceReference getSourceReference() {
            return this.fScript;
        }
    }
}

