/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.internal.ui.rubyeditor.ILinkedModeEditStrategy;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;

public class RubySourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private boolean fIgnoreTextConverters = false;
    protected final LinkedList fPositionList = new LinkedList();
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    protected static final String CATEGORY_AUTO_EDIT = "org.rubypeople.rdt.ui.RubyEditor.auto.edit." + System.currentTimeMillis();
    protected final IPositionUpdater fAutoEditUpdater;

    public RubySourceViewer(Composite composite, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean overviewRulerVisible, int styles, IPreferenceStore store) {
        super(composite, verticalRuler, overviewRuler, overviewRulerVisible, styles);
        this.setPreferenceStore(store);
        this.fAutoEditUpdater = new InclusivePositionUpdater(CATEGORY_AUTO_EDIT);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = store;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof RubySourceViewerConfiguration) {
            RubySourceViewerConfiguration javaSVCconfiguration = (RubySourceViewerConfiguration)configuration;
            this.fOutlinePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, false);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, true);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
        this.fIsConfigured = true;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public boolean canDoOperation(int operation) {
        if (operation == 51) {
            return this.fOutlinePresenter != null;
        }
        if (operation == 52) {
            return this.fStructurePresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
        }
        super.doOperation(operation);
    }

    protected final void handleVisibleDocumentChanged(DocumentEvent event) {
        super.handleVisibleDocumentChanged(event);
        if (!this.fPositionList.isEmpty()) {
            try {
                try {
                    final IDocument document = event.getDocument();
                    LinkedModeModel model = new LinkedModeModel();
                    final String category = CATEGORY_AUTO_EDIT;
                    if (!document.containsPositionCategory(category)) {
                        document.addPositionCategory(category);
                        document.addPositionUpdater(this.fAutoEditUpdater);
                        model.addLinkingListener(new ILinkedModeListener(){

                            public final void left(LinkedModeModel dummy, int flags) {
                                if (document.containsPositionCategory(category)) {
                                    try {
                                        document.removePositionCategory(category);
                                    }
                                    catch (BadPositionCategoryException badPositionCategoryException) {}
                                    document.removePositionUpdater(RubySourceViewer.this.fAutoEditUpdater);
                                }
                            }

                            public final void resume(LinkedModeModel dummy, int flags) {
                            }

                            public final void suspend(LinkedModeModel dummy) {
                            }
                        });
                    }
                    LinkedPosition position2 = null;
                    LinkedPositionGroup group = null;
                    for (LinkedPosition position2 : this.fPositionList) {
                        group = new LinkedPositionGroup();
                        group.addPosition(position2);
                        model.addGroup(group);
                    }
                    model.forceInstall();
                    LinkedModeUI handler = new LinkedModeUI(model, (ITextViewer)this);
                    LinkedPosition exit = (LinkedPosition)this.fPositionList.getFirst();
                    final LinkedPosition entry = (LinkedPosition)this.fPositionList.getLast();
                    this.addSelectionChangedListener(new ISelectionChangedListener(){
                        private boolean fHandled = false;

                        public final void selectionChanged(SelectionChangedEvent dummy) {
                            if (!this.fHandled) {
                                this.fHandled = true;
                                RubySourceViewer.this.removeSelectionChangedListener(this);
                            }
                        }
                    });
                    this.addPostSelectionChangedListener(new ISelectionChangedListener(){
                        private boolean fHandled = false;

                        public final void selectionChanged(SelectionChangedEvent dummy) {
                            if (!this.fHandled) {
                                RubySourceViewer.this.setSelectedRange(entry.offset, entry.length);
                                RubySourceViewer.this.invalidateTextPresentation(entry.offset, 0);
                                this.fHandled = true;
                                RubySourceViewer.this.removePostSelectionChangedListener(this);
                            }
                        }
                    });
                    handler.setExitPosition((ITextViewer)this, exit.offset, 0, -1);
                    handler.enter();
                }
                catch (BadLocationException badLocationException) {
                    this.fPositionList.clear();
                }
            }
            finally {
                this.fPositionList.clear();
            }
        }
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        if (this.isIgnoringAutoEditStrategies()) {
            return;
        }
        List strategies = (List)this.selectContentTypePlugin(command.offset, this.fAutoIndentStrategies);
        if (strategies == null) {
            return;
        }
        IDocument document = this.getDocument();
        if (!strategies.isEmpty()) {
            this.fPositionList.clear();
            String originalCommandText = command.text;
            LinkedPosition[] result = null;
            IAutoEditStrategy strategy2 = null;
            for (IAutoEditStrategy strategy2 : new ArrayList(strategies)) {
                strategy2.customizeDocumentCommand(document, command);
                if (!(strategy2 instanceof ILinkedModeEditStrategy) || !originalCommandText.equals("\t") || (result = ((ILinkedModeEditStrategy)strategy2).getLinkedPositions()) == null || result.length <= 0) continue;
                this.fPositionList.addAll((Collection)Arrays.asList(result));
            }
        }
    }
}

