/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SelectAnnotationRulerAction;
import org.rubypeople.rdt.internal.ui.rubyeditor.OverrideIndicatorManager;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionProcessor;

public class RubySelectMarkerRulerAction2
extends SelectAnnotationRulerAction {
    public RubySelectMarkerRulerAction2(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.java_select_marker_ruler_action");
    }

    public void annotationDefaultSelected(VerticalRulerEvent event) {
        ITextOperationTarget operation;
        Position position;
        Annotation annotation = event.getSelectedAnnotation();
        IAnnotationModel model = this.getAnnotationModel();
        if (this.isOverrideIndicator(annotation)) {
            ((OverrideIndicatorManager.OverrideIndicator)annotation).open();
            return;
        }
        if (this.isBreakpoint(annotation)) {
            this.triggerAction("RulerDoubleClick");
        }
        if ((position = model.getPosition(annotation)) == null) {
            return;
        }
        if (this.isQuickFixTarget(annotation) && (operation = (ITextOperationTarget)this.getTextEditor().getAdapter(ITextOperationTarget.class)) != null && operation.canDoOperation(22)) {
            this.getTextEditor().selectAndReveal(position.getOffset(), position.getLength());
            operation.doOperation(22);
            return;
        }
        super.annotationDefaultSelected(event);
    }

    private boolean isOverrideIndicator(Annotation annotation) {
        return annotation instanceof OverrideIndicatorManager.OverrideIndicator;
    }

    private boolean isBreakpoint(Annotation annotation) {
        return annotation.getType().equals("org.eclipse.debug.core.breakpoint");
    }

    private boolean isQuickFixTarget(Annotation a) {
        return RubyCorrectionProcessor.hasCorrections(a);
    }

    private void triggerAction(String actionID) {
        IAction action = this.getTextEditor().getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action instanceof ISelectionListener) {
                ((ISelectionListener)action).selectionChanged(null, null);
            }
            if (action.isEnabled()) {
                action.run();
            }
        }
    }
}

