/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Stack;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.actions.FoldingActionGroup;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.GotoMatchingBracketAction;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptDocumentProvider;
import org.rubypeople.rdt.internal.ui.rubyeditor.OverrideIndicatorManager;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAnnotationIterator;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySelectMarkerRulerAction2;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.rubyeditor.StringSubstitutionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.ToggleCommentAction;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.IRubyReconcilingListener;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.SourceViewerInformationControl;
import org.rubypeople.rdt.ui.actions.FormatAction;
import org.rubypeople.rdt.ui.actions.OpenEditorActionGroup;
import org.rubypeople.rdt.ui.actions.OpenViewActionGroup;
import org.rubypeople.rdt.ui.actions.RubyActionGroup;
import org.rubypeople.rdt.ui.actions.RubySearchActionGroup;
import org.rubypeople.rdt.ui.actions.ShowInRubyExplorerViewAction;
import org.rubypeople.rdt.ui.actions.SurroundWithBeginRescueAction;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProviderExtension;

public class RubyEditor
extends RubyAbstractEditor
implements IRubyReconcilingListener {
    private ProjectionSupport fProjectionSupport;
    private TabConverter fTabConverter;
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    private static final String CLOSE_BRACES = "closeBraces";
    private static final String CODE_FORMATTER_TAB_SIZE = "org.rubypeople.rdt.core.formatter.tabulation.size";
    private static final String SPACES_FOR_TABS = "org.rubypeople.rdt.core.formatter.tabulation.char";
    private final Object fReconcilerLock = new Object();
    private IRubyFoldingStructureProvider fProjectionModelUpdater;
    protected OverrideIndicatorManager fOverrideIndicatorManager;
    private boolean fIsUpdatingAnnotationViews = false;
    private IMarker fLastMarkerTarget = null;
    private ToggleFoldingRunner fFoldingRunner;
    private FoldingActionGroup fFoldingGroup;
    private ListenerList fReconcilingListeners = new ListenerList(1);
    private BracketInserter fBracketInserter = new BracketInserter();
    private CompositeActionGroup fActionGroups;
    private CompositeActionGroup fContextMenuGroup;
    private RubyActionGroup fGenerateActionGroup;
    private InformationPresenter fInformationPresenter;
    private StringSubstitutionConverter fStringConverter;

    public RubyEditor() {
        this.setDocumentProvider(RubyPlugin.getDefault().getRubyDocumentProvider());
        this.setRulerContextMenuId("org.rubypeople.rdt.ui.rubyeditor.rulerContextMenu");
        this.setEditorContextMenuId("org.rubypeople.rdt.ui.rubyeditor.contextMenu");
        this.setKeyBindingScopes(new String[]{"org.rubypeople.rdt.ui.rubyEditorScope"});
        this.setOutlinerContextMenuId("#RubyScriptOutlinerContext");
    }

    protected ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    protected void createActions() {
        super.createActions();
        ActionGroup[] actionGroupArray = new ActionGroup[3];
        OpenEditorActionGroup oeg = new OpenEditorActionGroup((AbstractTextEditor)this);
        actionGroupArray[0] = oeg;
        OpenViewActionGroup ovg = new OpenViewActionGroup(this);
        actionGroupArray[1] = ovg;
        RubySearchActionGroup rsg = new RubySearchActionGroup(this);
        actionGroupArray[2] = rsg;
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        this.fGenerateActionGroup = new RubyActionGroup(this, "group.edit");
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, rsg, this.fGenerateActionGroup});
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer());
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        ISelection selection = provider.getSelection();
        Object resAction = new TextOperationAction(RubyEditorMessages.getBundleForConstructedKeys(), "ShowRDoc.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(RubyEditorMessages.getBundleForConstructedKeys(), "ShowRDoc.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.show.rdoc");
        this.setAction("ShowRDoc", (IAction)resAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)resAction, "org.rubypeople.rdt.ui.show_javadoc_action");
        SurroundWithBeginRescueAction beginRescueAction = new SurroundWithBeginRescueAction(this);
        beginRescueAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.surround.with.begin.rescue");
        beginRescueAction.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)beginRescueAction);
        this.setAction("SurroundWithBeginRescue", (IAction)beginRescueAction);
        Object action = new ContentAssistAction((ResourceBundle)RubyPlugin.getDefault().getPluginProperties(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.content.assist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction((ResourceBundle)RubyPlugin.getDefault().getPluginProperties(), "CommentAction.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.comment");
        this.setAction("Comment", (IAction)action);
        action = new TextOperationAction((ResourceBundle)RubyPlugin.getDefault().getPluginProperties(), "UncommentAction.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.uncomment");
        this.setAction("Uncomment", (IAction)action);
        action = new ToggleCommentAction(RubyPlugin.getDefault().getPluginProperties(), "ToggleCommentAction.", (ITextEditor)this);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.rubypeople.rdt.ui.toggle_comment_action");
        this.configureToggleCommentAction();
        action = new RubySelectMarkerRulerAction2(RubyEditorMessages.getBundleForConstructedKeys(), "Editor.RulerAnnotationSelection.", (ITextEditor)this);
        this.setAction("AnnotationAction", (IAction)action);
        action = new ShowInRubyExplorerViewAction(this);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.show.in.ruby.resources.view");
        this.setAction("ShowInPackageView", (IAction)action);
        action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new TextOperationAction(RubyEditorMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 51, true);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.show.outline");
        this.setAction("org.rubypeople.rdt.ui.edit.text.ruby.show.outline", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.rubypeople.rdt.ui.show_outline_action");
        action = new TextOperationAction(RubyEditorMessages.getBundleForConstructedKeys(), "OpenStructure.", (ITextEditor)this, 52, true);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.navigate.ruby.open.structure");
        this.setAction("org.rubypeople.rdt.ui.navigate.ruby.open.structure", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.rubypeople.rdt.ui.open_structure_action");
        action = new TextOperationAction(RubyEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.", (ITextEditor)this, 53, true);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.open.hierarchy");
        this.setAction("org.rubypeople.rdt.ui.edit.text.ruby.open.hierarchy", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.rubypeople.rdt.ui.open_hierarchy_action");
        action = new FormatAction(RubyPlugin.getDefault().getPluginProperties(), "FormatAction.", (ITextEditor)this);
        action.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.format");
        this.setAction("Format", (IAction)action);
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.fInformationPresenter.setDocumentPartitioning("___ruby_partitioning");
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        this.startStringSubstitutionConverter();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
            boolean closeBraces = preferenceStore.getBoolean(CLOSE_BRACES);
            boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
            this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
            this.fBracketInserter.setCloseBracesEnabled(closeBraces);
            this.fBracketInserter.setCloseStringsEnabled(closeStrings);
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (sourceViewer instanceof ProjectionViewer && this.isFoldingEnabled()) {
            ProjectionViewer pv = (ProjectionViewer)sourceViewer;
            pv.doOperation(19);
        }
    }

    public void resetProjection() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(RubyEditorMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseMembers");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseComments");
        foldingMenu.add(action);
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        RubyAnnotationIterator e = new RubyAnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    private Annotation getNextAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        RubyAnnotationIterator e = new RubyAnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a instanceof IRubyAnnotation && ((IRubyAnnotation)a).hasOverlay() || !this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        Preferences preferences = EditorsUI.getPluginPreferences();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && preferences.getBoolean(key);
    }

    public Annotation gotoAnnotation(boolean forward) {
        Annotation annotation = null;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        annotation = this.getNextAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    private void updateAnnotationViews(Annotation annotation) {
        Iterator e;
        IMarker marker = null;
        if (annotation instanceof MarkerAnnotation) {
            marker = ((MarkerAnnotation)annotation).getMarker();
        } else if (annotation instanceof IRubyAnnotation && (e = ((IRubyAnnotation)annotation).getOverlaidIterator()) != null) {
            while (e.hasNext()) {
                Object o = e.next();
                if (!(o instanceof MarkerAnnotation)) continue;
                marker = ((MarkerAnnotation)o).getMarker();
                break;
            }
        }
        if (marker != null && !marker.equals((Object)this.fLastMarkerTarget)) {
            try {
                boolean isProblem = marker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
                IWorkbenchPage page = this.getSite().getPage();
                IViewPart view = page.findView(isProblem ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList");
                if (view != null) {
                    Method method = view.getClass().getMethod("setSelection", IStructuredSelection.class, Boolean.TYPE);
                    method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                }
            }
            catch (CoreException coreException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void gotoMarker(IMarker marker) {
        this.fLastMarkerTarget = marker;
        if (!this.fIsUpdatingAnnotationViews) {
            super.gotoMarker(marker);
        }
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            try {
                this.fIsUpdatingAnnotationViews = true;
                this.updateAnnotationViews(annotation);
            }
            finally {
                this.fIsUpdatingAnnotationViews = false;
            }
            if (annotation instanceof IRubyAnnotation && ((IRubyAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    boolean isFoldingEnabled() {
        return RubyPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        super.dispose();
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IEncodingSupport.class.equals((Object)required)) {
            return this.fEncodingSupport;
        }
        if (required == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (required == IShowInSource.class) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(RubyEditor.this.getEditorInput(), null){

                        public ISelection getSelection() {
                            IRubyElement re;
                            block3: {
                                re = null;
                                try {
                                    re = SelectionConverter.getElementAtOffset(RubyEditor.this);
                                    if (re != null) break block3;
                                    return null;
                                }
                                catch (RubyModelException rubyModelException) {
                                    return null;
                                }
                            }
                            return new StructuredSelection((Object)re);
                        }
                    };
                }
            };
        }
        if (required == IRubyFoldingStructureProvider.class) {
            return this.fProjectionModelUpdater;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configureTabConverter();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
        if (this.isShowingOverrideIndicators()) {
            this.installOverrideIndicator(false);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
        IAction action = this.getAction("org.rubypeople.rdt.ui.edit.text.ruby.show.outline");
        menu.appendToGroup("group.open", action);
        action = this.getAction("org.rubypeople.rdt.ui.edit.text.ruby.open.hierarchy");
        menu.appendToGroup("group.open", action);
        this.addExtensionMenuItems(menu);
    }

    private void addExtensionMenuItems(IMenuManager menu) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.rubypeople.rdt.ui.editorPopupExtender");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                SelectionEnabler selectionEnabler = new SelectionEnabler(element);
                if (selectionEnabler.isEnabledForSelection(this.getSelectionProvider().getSelection())) {
                    try {
                        Object menuExtender = element.createExecutableExtension("class");
                        if (!(menuExtender instanceof ActionGroup)) {
                            String message = "The editorPopupExtender" + element.getName() + " is of type " + menuExtender.getClass().getName() + " , but should be of type ActionGroup";
                            RubyPlugin.log(4, message, null);
                        } else {
                            ActionGroup menuExtenderActionGroup = (ActionGroup)menuExtender;
                            menuExtenderActionGroup.setContext(new ActionContext(this.getSelectionProvider().getSelection()));
                            menuExtenderActionGroup.fillContextMenu(menu);
                        }
                    }
                    catch (CoreException e) {
                        RubyPlugin.log(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        String property = event.getProperty();
        if (CLOSE_BRACKETS.equals(property)) {
            this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(property));
            return;
        }
        if (CLOSE_BRACES.equals(property)) {
            this.fBracketInserter.setCloseBracesEnabled(this.getPreferenceStore().getBoolean(property));
            return;
        }
        if (CLOSE_STRINGS.equals(property)) {
            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(property));
            return;
        }
        RubyAbstractEditor.AdaptedSourceViewer sourceViewer = (RubyAbstractEditor.AdaptedSourceViewer)this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        if (SPACES_FOR_TABS.equals(property)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        if (CODE_FORMATTER_TAB_SIZE.equals(property)) {
            sourceViewer.updateIndentationPrefixes();
            if (this.fTabConverter != null) {
                this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            }
        }
        if ("editor_folding_provider".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                RubyAbstractEditor.AdaptedSourceViewer projectionViewer = sourceViewer;
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
                this.fProjectionModelUpdater = RubyPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
            }
            return;
        }
        if ("editor_folding_enabled".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                new ToggleFoldingRunner().runWhenNextVisible();
            }
            return;
        }
    }

    protected ISourceViewer createRubySourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        RubyAbstractEditor.AdaptedSourceViewer viewer = new RubyAbstractEditor.AdaptedSourceViewer(parent, verticalRuler, overviewRuler, isOverviewRulerVisible, styles, store);
        if (viewer instanceof RubySourceViewer) {
        }
        ProjectionViewer projectionViewer = viewer;
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell, 0xC | RubyEditor.this.getOrientation(), 0);
            }
        });
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = RubyPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        return viewer;
    }

    public Object getReconcilerLock() {
        return this.fReconcilerLock;
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
            case '`': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setCaretPosition(CaretPosition pos) {
        try {
            int lineOffset = this.getSourceViewer().getDocument().getLineOffset(pos.line);
            this.selectAndReveal(lineOffset + pos.column, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public CaretPosition getCaretPosition() {
        StyledText styledText = this.getSourceViewer().getTextWidget();
        int caret = RubyEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)styledText.getCaretOffset());
        IDocument document = this.getSourceViewer().getDocument();
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            return new CaretPosition(line, caret - lineOffset, caret);
        }
        catch (BadLocationException badLocationException) {
            return new CaretPosition(0, 0);
        }
    }

    protected IRubyElement getElementAt(int offset, boolean reconcile) {
        block5: {
            WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
            IRubyScript unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        RubyModelUtil.reconcile(unit);
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (RubyModelException x) {
                    if (x.isDoesNotExist()) break block5;
                    RubyPlugin.log(x.getStatus());
                }
            }
        }
        return null;
    }

    protected IRubyElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_invalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (RubyEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = RubyEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return RubyEditor.isBracket(document.getChar(offset - 1)) && RubyEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void collapseMembers() {
        if (this.fProjectionModelUpdater instanceof IRubyFoldingStructureProviderExtension) {
            IRubyFoldingStructureProviderExtension extension = (IRubyFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseMembers();
        }
    }

    public void collapseComments() {
        if (this.fProjectionModelUpdater instanceof IRubyFoldingStructureProviderExtension) {
            IRubyFoldingStructureProviderExtension extension = (IRubyFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseComments();
        }
    }

    public FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    private int getTabSize() {
        IRubyElement element = this.getInputRubyElement();
        IRubyProject project = element == null ? null : element.getRubyProject();
        return CodeFormatterUtil.getTabWidth(project);
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            RubyAbstractEditor.AdaptedSourceViewer asv = (RubyAbstractEditor.AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
        }
    }

    private void startStringSubstitutionConverter() {
        if (this.fStringConverter == null) {
            this.fStringConverter = new StringSubstitutionConverter(this);
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof IRubyScriptDocumentProvider) {
                IRubyScriptDocumentProvider cup = (IRubyScriptDocumentProvider)provider;
                this.fStringConverter.setLineTracker(cup.createLineTracker(this.getEditorInput()));
            }
            RubyAbstractEditor.AdaptedSourceViewer asv = (RubyAbstractEditor.AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fStringConverter);
        }
    }

    private void configureTabConverter() {
        IDocumentProvider provider;
        if (this.fTabConverter != null && (provider = this.getDocumentProvider()) instanceof IRubyScriptDocumentProvider) {
            IRubyScriptDocumentProvider cup = (IRubyScriptDocumentProvider)provider;
            this.fTabConverter.setLineTracker(cup.createLineTracker(this.getEditorInput()));
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            RubyAbstractEditor.AdaptedSourceViewer asv = (RubyAbstractEditor.AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IRubyElement element = this.getInputRubyElement();
        IRubyProject project = element == null ? null : element.getRubyProject();
        String option = project == null ? RubyCore.getOption((String)SPACES_FOR_TABS) : project.getOption(SPACES_FOR_TABS, true);
        return "space".equals(option);
    }

    protected boolean isShowingOverrideIndicators() {
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.rubypeople.rdt.ui.overrideIndicator");
        IPreferenceStore store = this.getPreferenceStore();
        return this.getBoolean(store, preference.getHighlightPreferenceKey()) || this.getBoolean(store, preference.getVerticalRulerPreferenceKey()) || this.getBoolean(store, preference.getOverviewRulerPreferenceKey()) || this.getBoolean(store, preference.getTextPreferenceKey());
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key != null && store.getBoolean(key);
    }

    protected void installOverrideIndicator(boolean provideAST) {
        this.uninstallOverrideIndicator();
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        final IRubyElement inputElement = this.getInputRubyElement();
        if (model == null || inputElement == null) {
            return;
        }
        this.fOverrideIndicatorManager = new OverrideIndicatorManager(model, inputElement, null);
        if (provideAST) {
            Job job = new Job("Installing override indicators..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (RubyEditor.this.fOverrideIndicatorManager != null) {
                        RubyEditor.this.fOverrideIndicatorManager.reconciled((IRubyScript)inputElement, null, true, monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }
        if (this.fOverrideIndicatorManager == null) {
            return;
        }
        this.addReconcileListener(this.fOverrideIndicatorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addReconcileListener(IRubyReconcilingListener listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    protected void uninstallOverrideIndicator() {
        if (this.fOverrideIndicatorManager != null) {
            this.fOverrideIndicatorManager.removeAnnotations();
            this.fOverrideIndicatorManager = null;
        }
    }

    protected boolean affectsOverrideIndicatorAnnotations(PropertyChangeEvent event) {
        String key = event.getProperty();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference("org.rubypeople.rdt.ui.overrideIndicator");
        if (key == null || preference == null) {
            return false;
        }
        return key.equals(preference.getHighlightPreferenceKey()) || key.equals(preference.getVerticalRulerPreferenceKey()) || key.equals(preference.getOverviewRulerPreferenceKey()) || key.equals(preference.getTextPreferenceKey());
    }

    public void aboutToBeReconciled() {
        RubyPlugin.getDefault().getASTProvider().aboutToBeReconciled(this.getInputRubyElement());
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IRubyReconcilingListener)listeners[i]).aboutToBeReconciled();
            ++i;
        }
    }

    public void reconciled(IRubyScript script, RootNode ast, boolean forced, IProgressMonitor progressMonitor) {
        Shell shell;
        RubyPlugin javaPlugin = RubyPlugin.getDefault();
        if (javaPlugin == null) {
            return;
        }
        javaPlugin.getASTProvider().reconciled(ast, this.getInputRubyElement(), progressMonitor);
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IRubyReconcilingListener)listeners[i]).reconciled(script, ast, forced, progressMonitor);
            ++i;
        }
        if (!(forced || progressMonitor.isCanceled() || (shell = this.getSite().getShell()) == null || shell.isDisposed())) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    RubyEditor.this.selectionChanged();
                }
            });
        }
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private boolean fCloseBraces = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Stack fBracketLevelStack = new Stack();

        private BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void setCloseBracesEnabled(boolean enabled) {
            this.fCloseBraces = enabled;
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '`': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = RubyEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                String selected = document.get(offset, length);
                if (selected != null && selected.length() > 0 && (event.character == '\"' || event.character == '\'')) {
                    return;
                }
                IRegion startLine = document.getLineInformationOfOffset(offset);
                RubyHeuristicScanner scanner = new RubyHeuristicScanner(document);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                int prevTokenOffset = scanner.getPosition() + 1;
                String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBraces && nextToken != 1 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (this.fCloseStrings && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___ruby_partitioning", (int)(offset - 1), (boolean)true);
                if (event.character == '{' && previous != null && previous.endsWith("#") && partition != null && partition.getType() != null ? !"__dftl_partition_content_type".equals(partition.getType()) && !"__ruby_string".equals(partition.getType()) : !"__dftl_partition_content_type".equals(partition.getType())) {
                    return;
                }
                if (!RubyEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = RubyEditor.getPeerCharacter(character);
                StringBuffer buffer = new StringBuffer();
                buffer.append(character);
                buffer.append(closingCharacter);
                document.replace(offset, length, buffer.toString());
                BracketLevel level = new BracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                level.fOffset = offset;
                level.fLength = 2;
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, RubyEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                RubyPlugin.log(e);
            }
            catch (BadPositionCategoryException e) {
                RubyPlugin.log(e);
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = RubyEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException e) {
                                RubyPlugin.log(e);
                            }
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                RubyPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    public class CaretPosition {
        private int line;
        private int column;
        private int offset;

        public CaretPosition(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public CaretPosition(int line, int column, int offset) {
            this(line, column);
            this.offset = offset;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                BracketLevel level = (BracketLevel)this.fStack.peek();
                if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                    return null;
                }
                if (level.fSecondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = RubyEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)RubyEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = RubyEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
            this.fTextOperationAction.run();
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            RubyEditor.this.fInformationPresenter.setOffset(offset);
            RubyEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            RubyEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"___ruby_partitioning", (int)offset, (boolean)true);
            RubyEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            RubyEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = RubyEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"___ruby_partitioning", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(annotationHover.getClass().getName())) {
                    controlCreator = new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell shell) {
                            int shellStyle = 0x14 | RubyEditor.this.getOrientation();
                            int style = 768;
                            return new SourceViewerInformationControl(shell, shellStyle, style);
                        }
                    };
                } else if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                RubyEditor.this.fInformationPresenter.setOffset(offset);
                RubyEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                RubyEditor.this.fInformationPresenter.setMargins(4, 0);
                RubyEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                RubyEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }

    public static class TabConverter
    implements ITextConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        private ToggleFoldingRunner() {
        }

        private void toggleFolding() {
            ProjectionViewer pv;
            ISourceViewer sourceViewer = RubyEditor.this.getSourceViewer();
            if (sourceViewer instanceof ProjectionViewer && (pv = (ProjectionViewer)sourceViewer).isProjectionMode() != RubyEditor.this.isFoldingEnabled() && pv.canDoOperation(19)) {
                pv.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage page;
            if (RubyEditor.this.fFoldingRunner != null) {
                RubyEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite site = RubyEditor.this.getSite();
            if (site != null && !(page = site.getPage()).isPartVisible((IWorkbenchPart)RubyEditor.this)) {
                this.fPage = page;
                RubyEditor.this.fFoldingRunner = this;
                page.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (RubyEditor.this.fFoldingRunner == this) {
                RubyEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (RubyEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (RubyEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

