/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.rubypeople.rdt.internal.ui.rubyeditor.ILinkedModeEditStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.LegacyRubyCompletionProcessor;

public class RubyAutoEditStrategy
implements ILinkedModeEditStrategy {
    private LegacyRubyCompletionProcessor fRubyCp;
    private ISourceViewer fViewer;
    protected final List fPositionList = new ArrayList();

    public RubyAutoEditStrategy(String partition, ISourceViewer viewer, LegacyRubyCompletionProcessor rhtmlCp) {
        this.fViewer = viewer;
        this.fRubyCp = rhtmlCp;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        block12: {
            this.fPositionList.clear();
            if (command.text.length() == 1 && command.text.charAt(0) == '\t') {
                try {
                    int length = 0;
                    while (command.offset - length > 0 && Pattern.matches("\\w", document.get(command.offset - length - 1, 1))) {
                        ++length;
                    }
                    String prefix = document.get(command.offset - length, length);
                    Region region = new Region(command.offset - prefix.length(), prefix.length());
                    if (prefix.length() <= 0) break block12;
                    Template[] templates = this.fRubyCp.getTemplates("ruby");
                    int i = 0;
                    while (i < templates.length) {
                        Template template = templates[i];
                        if (template.getName().equals(prefix)) {
                            String templateString;
                            TemplateBuffer templateBuffer;
                            int offset = command.offset - prefix.length();
                            TemplateContextType contextType = this.fRubyCp.getContextType((ITextViewer)this.fViewer, (IRegion)region);
                            DocumentTemplateContext context = new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
                            context.setReadOnly(false);
                            try {
                                templateBuffer = context.evaluate(template);
                            }
                            catch (TemplateException templateException) {
                                return;
                            }
                            int start = this.getReplaceOffset((TemplateContext)context, region);
                            int end = Math.max(this.getReplaceEndOffset((TemplateContext)context, region), offset);
                            command.text = templateString = templateBuffer.getString();
                            command.offset = start;
                            command.length = end - start;
                            this.fPositionList.add(new LinkedPosition(document, offset + templateString.length(), 0));
                            TemplateVariable[] variables = templateBuffer.getVariables();
                            int z = 0;
                            while (z != variables.length) {
                                TemplateVariable variable = variables[z];
                                if (!variable.isUnambiguous()) {
                                    int[] offsets = variable.getOffsets();
                                    int variablelength = variable.getLength();
                                    int j = 0;
                                    while (j != offsets.length) {
                                        this.fPositionList.add(new LinkedPosition(document, offsets[j] + start, variablelength));
                                        ++j;
                                    }
                                }
                                ++z;
                            }
                            break;
                        }
                        ++i;
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public LinkedPosition[] getLinkedPositions() {
        int size = this.fPositionList.size();
        if (size > 0) {
            LinkedPosition[] positions = new LinkedPosition[size];
            this.fPositionList.toArray(positions);
            return positions;
        }
        return null;
    }

    protected final int getReplaceOffset(TemplateContext context, Region region) {
        int start;
        if (context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)context;
            start = docContext.getStart();
        } else {
            start = region.getOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset(TemplateContext context, Region region) {
        int end;
        if (context instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)context;
            end = docContext.getEnd();
        } else {
            end = region.getOffset() + region.getLength();
        }
        return end;
    }
}

