/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;

public class RubyAnnotationIterator
implements Iterator {
    private Iterator fIterator;
    private Annotation fNext;
    private boolean fSkipIrrelevants;
    private boolean fReturnAllAnnotations;

    public RubyAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants) {
        this(model, skipIrrelevants, false);
    }

    public RubyAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = model != null ? model.getAnnotationIterator() : Collections.EMPTY_LIST.iterator();
        this.fSkipIrrelevants = skipIrrelevants;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = (Annotation)this.fIterator.next();
            if (next instanceof IRubyAnnotation) {
                if (this.fSkipIrrelevants) {
                    if (next.isMarkedDeleted()) continue;
                    this.fNext = next;
                    return;
                }
                this.fNext = next;
                return;
            }
            if (!this.fReturnAllAnnotations) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    public boolean hasNext() {
        return this.fNext != null;
    }

    public Object next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

