/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public final class ASTProvider {
    public static final WAIT_FLAG WAIT_YES = new WAIT_FLAG("wait yes");
    public static final WAIT_FLAG WAIT_ACTIVE_ONLY = new WAIT_FLAG("wait active only");
    public static final WAIT_FLAG WAIT_NO = new WAIT_FLAG("don't wait");
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.rubypeople.rdt.ui/debug/ASTProvider"));
    public static final boolean SHARED_AST_STATEMENT_RECOVERY = true;
    private static final String DEBUG_PREFIX = "ASTProvider > ";
    private IRubyElement fReconcilingRubyElement;
    private IRubyElement fActiveRubyElement;
    private RootNode fAST;
    private ActivationListener fActivationListener;
    private Object fReconcileLock = new Object();
    private Object fWaitLock = new Object();
    private boolean fIsReconciling;
    private IWorkbenchPart fActiveEditor;

    public static ASTProvider getASTProvider() {
        return RubyPlugin.getDefault().getASTProvider();
    }

    public ASTProvider() {
        this.install();
    }

    void install() {
        this.fActivationListener = new ActivationListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        int length = windows.length;
        while (i < length) {
            windows[i].getPartService().addPartListener((IPartListener2)this.fActivationListener);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeRubyEditorChanged(IWorkbenchPart editor) {
        IRubyElement rubyElement = null;
        if (editor instanceof RubyEditor) {
            rubyElement = ((RubyEditor)editor).getInputRubyElement();
        }
        Object object = this;
        synchronized (object) {
            this.fActiveEditor = editor;
            this.fActiveRubyElement = rubyElement;
            this.cache(null, rubyElement);
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "active editor is: " + this.toString(rubyElement));
        }
        object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling && (this.fReconcilingRubyElement == null || !this.fReconcilingRubyElement.equals(rubyElement))) {
                this.fIsReconciling = false;
                this.fReconcilingRubyElement = null;
            } else if (rubyElement == null) {
                this.fIsReconciling = false;
                this.fReconcilingRubyElement = null;
            }
        }
    }

    public boolean isCached(Node ast) {
        return ast != null && this.fAST == ast;
    }

    public boolean isActive(IRubyScript cu) {
        return cu != null && cu.equals(this.fActiveRubyElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aboutToBeReconciled(IRubyElement rubyElement) {
        if (rubyElement == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "about to reconcile: " + this.toString(rubyElement));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = true;
            this.fReconcilingRubyElement = rubyElement;
        }
        this.cache(null, rubyElement);
    }

    private synchronized void disposeAST() {
        if (this.fAST == null) {
            return;
        }
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "disposing AST: " + this.toString((Node)this.fAST) + " for: " + this.toString(this.fActiveRubyElement));
        }
        this.fAST = null;
        this.cache(null, null);
    }

    private String toString(IRubyElement javaElement) {
        if (javaElement == null) {
            return "null";
        }
        return javaElement.getElementName();
    }

    private String toString(Node ast) {
        if (ast == null) {
            return "null";
        }
        return ASTUtil.stringRepresentation((Node)ast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cache(RootNode ast, IRubyElement javaElement) {
        if (this.fActiveRubyElement != null && !this.fActiveRubyElement.equals(javaElement)) {
            if (DEBUG && javaElement != null) {
                System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "don't cache AST for inactive: " + this.toString(javaElement));
            }
            return;
        }
        if (DEBUG && (javaElement != null || ast != null)) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "caching AST: " + this.toString((Node)ast) + " for: " + this.toString(javaElement));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RootNode getAST(IRubyElement re, WAIT_FLAG waitFlag, IProgressMonitor progressMonitor) {
        boolean isActiveElement;
        if (re == null) {
            return null;
        }
        Assert.isTrue((re.getElementType() == 4 ? 1 : 0) != 0);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ASTProvider aSTProvider = this;
        synchronized (aSTProvider) {
            isActiveElement = re.equals(this.fActiveRubyElement);
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "returning cached AST:" + this.toString((Node)this.fAST) + " for: " + re.getElementName());
                    return this.fAST;
                }
                if (waitFlag == WAIT_NO) {
                    if (!DEBUG) return null;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "returning null (WAIT_NO) for: " + re.getElementName());
                    return null;
                }
            }
        }
        if (isActiveElement && this.isReconciling(re)) {
            try {
                IRubyElement activeElement = this.fReconcilingRubyElement;
                Object object = this.fWaitLock;
                synchronized (object) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "waiting for AST for: " + re.getElementName());
                    }
                    this.fWaitLock.wait();
                }
                object = this;
                synchronized (object) {
                    if (activeElement != this.fActiveRubyElement) return this.getAST(re, waitFlag, progressMonitor);
                    if (this.fAST == null) return this.getAST(re, waitFlag, progressMonitor);
                    if (!DEBUG) return this.fAST;
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "...got AST for: " + re.getElementName());
                    return this.fAST;
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        if (waitFlag == WAIT_NO) return null;
        if (waitFlag == WAIT_ACTIVE_ONLY) {
            if (!isActiveElement) return null;
            if (this.fAST != null) {
                return null;
            }
        }
        if (isActiveElement) {
            this.aboutToBeReconciled(re);
        }
        RootNode ast = null;
        try {
            ast = this.createAST(re, progressMonitor);
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                ast = null;
                return ast;
            }
            if (!DEBUG) return ast;
            if (ast == null) return ast;
            System.err.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "created AST for: " + re.getElementName());
            return ast;
        }
        finally {
            if (isActiveElement) {
                if (this.fAST != null) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "Ignore created AST for " + re.getElementName() + "- AST from reconciler is newer");
                    }
                    this.reconciled(this.fAST, re, null);
                } else {
                    this.reconciled(ast, re, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReconciling(IRubyElement javaElement) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            return javaElement != null && javaElement.equals(this.fReconcilingRubyElement) && this.fIsReconciling;
        }
    }

    private RootNode createAST(IRubyElement je, final IProgressMonitor progressMonitor) {
        if (!this.hasSource(je)) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final RubyParser parser = new RubyParser();
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        if (je.getElementType() != 4) {
            return null;
        }
        IRubyScript script = (IRubyScript)je;
        String source = null;
        try {
            source = script.getSource();
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
        final String goodSource = source;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final RootNode[] root = new RootNode[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                try {
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        root[0] = null;
                    }
                    root[0] = (RootNode)parser.parse(goodSource).getAST();
                }
                catch (OperationCanceledException operationCanceledException) {
                    root[0] = null;
                }
                catch (SyntaxException syntaxException) {
                    root[0] = null;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.rubypeople.rdt.ui", 0, "Error in RDT Core during AST creation", ex);
                RubyPlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }

    private boolean hasSource(IRubyElement re) {
        if (re == null || !re.exists()) {
            return false;
        }
        try {
            return re instanceof ISourceReference && ((ISourceReference)re).getSource() != null;
        }
        catch (RubyModelException ex) {
            Status status = new Status(4, "org.rubypeople.rdt.ui", 0, "Error in RDT Core during AST creation", (Throwable)ex);
            RubyPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
        this.fActivationListener = null;
        this.disposeAST();
        Object object = this.fWaitLock;
        synchronized (object) {
            this.fWaitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconciled(RootNode ast, IRubyElement javaElement, IProgressMonitor progressMonitor) {
        if (DEBUG) {
            System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "reconciled: " + this.toString(javaElement) + ", AST: " + this.toString((Node)ast));
        }
        Object object = this.fReconcileLock;
        synchronized (object) {
            boolean bl = this.fIsReconciling = progressMonitor != null && progressMonitor.isCanceled();
            if (javaElement == null || !javaElement.equals(this.fReconcilingRubyElement)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(this.getThreadName()) + " - " + DEBUG_PREFIX + "  ignoring AST of out-dated editor");
                }
                Object object2 = this.fWaitLock;
                synchronized (object2) {
                    this.fWaitLock.notifyAll();
                }
                return;
            }
            this.cache(ast, javaElement);
        }
    }

    private String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return name;
        }
        return Thread.currentThread().toString();
    }

    private class ActivationListener
    implements IPartListener2,
    IWindowListener {
        private ActivationListener() {
        }

        public void partActivated(IWorkbenchPartReference ref) {
            if (this.isRubyEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
            if (this.isRubyEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void partClosed(IWorkbenchPartReference ref) {
            if (this.isActiveEditor(ref)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ref.getTitle());
                }
                ASTProvider.this.activeRubyEditorChanged(null);
            }
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
            if (this.isRubyEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (this.isRubyEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (this.isRubyEditor(ref) && this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPartReference ref = window.getPartService().getActivePartReference();
            if (this.isRubyEditor(ref) && !this.isActiveEditor(ref)) {
                ASTProvider.this.activeRubyEditorChanged(ref.getPart(true));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (ASTProvider.this.fActiveEditor != null && ASTProvider.this.fActiveEditor.getSite() != null && window == ASTProvider.this.fActiveEditor.getSite().getWorkbenchWindow()) {
                if (DEBUG) {
                    System.out.println(String.valueOf(ASTProvider.this.getThreadName()) + " - " + ASTProvider.DEBUG_PREFIX + "closed active editor: " + ASTProvider.this.fActiveEditor.getTitle());
                }
                ASTProvider.this.activeRubyEditorChanged(null);
            }
            window.getPartService().removePartListener((IPartListener2)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener((IPartListener2)this);
        }

        private boolean isActiveEditor(IWorkbenchPartReference ref) {
            return ref != null && this.isActiveEditor(ref.getPart(false));
        }

        private boolean isActiveEditor(IWorkbenchPart part) {
            return part != null && part == ASTProvider.this.fActiveEditor;
        }

        private boolean isRubyEditor(IWorkbenchPartReference ref) {
            if (ref == null) {
                return false;
            }
            String id = ref.getId();
            return "org.rubypeople.rdt.ui.EditorRubyFile".equals(id) || "org.rubypeople.rdt.ui.ExternalRubyEditor".equals(id) || ref.getPart(false) instanceof RubyEditor;
        }
    }

    public static final class WAIT_FLAG {
        String fName;

        private WAIT_FLAG(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

