/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;

public class CreateProfileDialog
extends StatusDialog {
    private static final String PREF_OPEN_EDIT_DIALOG = "org.rubypeople.rdt.ui.codeformatter.create_profile_dialog.open_edit";
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_name_is_empty);
    private static final StatusInfo fDuplicate = new StatusInfo(4, FormatterMessages.CreateProfileDialog_status_message_profile_with_this_name_already_exists);
    private final ProfileManager fProfileManager;
    private final List fSortedProfiles;
    private final String[] fSortedNames;
    private ProfileManager.CustomProfile fCreatedProfile;
    protected boolean fOpenEditDialog;

    public CreateProfileDialog(Shell parentShell, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.CreateProfileDialog_dialog_title);
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText(FormatterMessages.CreateProfileDialog_profile_name_label_text);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText(FormatterMessages.CreateProfileDialog_base_profile_label_text);
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite, 32);
        this.fEditCheckbox.setText(FormatterMessages.CreateProfileDialog_open_edit_dialog_checkbox_text);
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IDialogSettings dialogSettings = RubyPlugin.getDefault().getDialogSettings();
        this.fOpenEditDialog = dialogSettings.get(PREF_OPEN_EDIT_DIALOG) != null ? dialogSettings.getBoolean(PREF_OPEN_EDIT_DIALOG) : true;
        this.fEditCheckbox.setSelection(this.fOpenEditDialog);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fProfileManager.getProfile("org.rubypeople.rdt.ui.default.eclipse_profile").getName());
        this.updateStatus(fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus(fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus(fEmpty);
            return;
        }
        this.updateStatus(fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        RubyPlugin.getDefault().getDialogSettings().put(PREF_OPEN_EDIT_DIALOG, this.fOpenEditDialog);
        HashMap baseSettings = new HashMap(((ProfileManager.Profile)this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex())).getSettings());
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = new ProfileManager.CustomProfile(profileName, baseSettings, 1);
        this.fProfileManager.addProfile(this.fCreatedProfile);
        super.okPressed();
    }

    public final ProfileManager.CustomProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

