/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIException;
import org.rubypeople.rdt.internal.ui.RubyUIStatus;
import org.rubypeople.rdt.internal.ui.preferences.RubyEditorColoringConfigurationBlock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxColoringStore {
    private static final int CURRENT_VERSION = 1;
    private static final String XML_NODE_ROOT = "colors";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_VALUE = "value";

    public static void write(List<RubyEditorColoringConfigurationBlock.HighlightingColorListItem> colors, File file) throws RubyUIException {
        try {
            FileOutputStream writer = new FileOutputStream(file);
            try {
                SyntaxColoringStore.writeToStream(colors, writer);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)writer).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw SyntaxColoringStore.createException(e, "Problems serializing the profiles to XML");
        }
    }

    private static void writeToStream(List<RubyEditorColoringConfigurationBlock.HighlightingColorListItem> colors, OutputStream stream) throws RubyUIException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            rootElement.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(1));
            document.appendChild(rootElement);
            for (RubyEditorColoringConfigurationBlock.HighlightingColorListItem item : colors) {
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getColorKey(), "");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getBackgroundKey(), "");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getBackgroundEnabledKey(), "false");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getBoldKey(), "false");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getItalicKey(), "false");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getStrikethroughKey(), "false");
                SyntaxColoringStore.addKeyValuePair(document, rootElement, item.getUnderlineKey(), "false");
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw SyntaxColoringStore.createException(e, "Problems serializing the profiles to XML");
        }
        catch (ParserConfigurationException e) {
            throw SyntaxColoringStore.createException(e, "Problems serializing the profiles to XML");
        }
    }

    private static void addKeyValuePair(Document document, Element rootElement, String key, String defaultValue) {
        String value = RubyPlugin.getDefault().getPreferenceStore().getString(key);
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        Element setting = document.createElement(XML_NODE_SETTING);
        setting.setAttribute(XML_ATTRIBUTE_ID, key);
        setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
        rootElement.appendChild(setting);
    }

    private static RubyUIException createException(Throwable t, String message) {
        return new RubyUIException(RubyUIStatus.createError(4, message, t));
    }

    public static Map<String, String> readFromFile(File file) throws RubyUIException {
        Map<String, String> map;
        FileInputStream reader = new FileInputStream(file);
        try {
            map = SyntaxColoringStore.readFromStream(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (IOException e) {
                throw SyntaxColoringStore.createException(e, "Problems reading profiles from XML.");
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return map;
    }

    private static Map<String, String> readFromStream(InputSource inputSource) throws RubyUIException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw SyntaxColoringStore.createException(e, "Problems reading profiles from XML.");
        }
        catch (IOException e) {
            throw SyntaxColoringStore.createException(e, "Problems reading profiles from XML.");
        }
        catch (ParserConfigurationException e) {
            throw SyntaxColoringStore.createException(e, "Problems reading profiles from XML.");
        }
        return handler.getProfiles();
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private Map fSettings;

        private ProfileDefaultHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(SyntaxColoringStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(SyntaxColoringStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(SyntaxColoringStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(SyntaxColoringStore.XML_NODE_ROOT)) {
                this.fSettings = new HashMap(200);
            }
        }

        public void endElement(String uri, String localName, String qName) {
        }

        public Map getProfiles() {
            return this.fSettings;
        }
    }
}

