/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.preferences.ScrolledPageContent;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemSeveritiesConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String SETTINGS_SECTION_NAME = null;
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static OptionsConfigurationBlock.Key[] fgKeys;
    private static Map<String, String> fgCategories;
    private static HashMap<String, List<Error>> fgErrors;
    private PixelConverter fPixelConverter;
    private IStatus fStatus = new StatusInfo();

    public ProblemSeveritiesConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ProblemSeveritiesConfigurationBlock.getKeys(), container);
    }

    private static List<IConfigurationElement> getErrorProviderElements() {
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.core", "errorProvider");
        if (extension == null) {
            return elements;
        }
        IExtension[] extensions = extension.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                elements.add(configElements[j]);
                ++j;
            }
            ++i;
        }
        return elements;
    }

    private static Map<String, String> getErrorCategories() {
        if (fgCategories != null) {
            return fgCategories;
        }
        HashMap<String, String> categories = new HashMap<String, String>();
        List<IConfigurationElement> configElements = ProblemSeveritiesConfigurationBlock.getErrorProviderElements();
        for (IConfigurationElement configElement : configElements) {
            String name = configElement.getName();
            configElement.getContributor().getName();
            if (!name.equals("category")) continue;
            categories.put(configElement.getAttribute("id"), configElement.getAttribute("name"));
        }
        fgCategories = categories;
        return fgCategories;
    }

    private static OptionsConfigurationBlock.Key[] getKeys() {
        if (fgKeys != null) {
            return fgKeys;
        }
        ArrayList<OptionsConfigurationBlock.Key> keys = new ArrayList<OptionsConfigurationBlock.Key>();
        Map<String, String> categories = ProblemSeveritiesConfigurationBlock.getErrorCategories();
        for (String categoryId : categories.keySet()) {
            List<Error> errors = ProblemSeveritiesConfigurationBlock.getErrors(categoryId);
            for (Error error : errors) {
                keys.add(ProblemSeveritiesConfigurationBlock.getKey(error.getContributor(), error.getId()));
            }
        }
        fgKeys = keys.toArray(new OptionsConfigurationBlock.Key[keys.size()]);
        return fgKeys;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createStyleTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.ProblemSeveritiesConfigurationBlock_error, PreferencesMessages.ProblemSeveritiesConfigurationBlock_warning, PreferencesMessages.ProblemSeveritiesConfigurationBlock_ignore};
        String[] stringArray = new String[]{ENABLED, DISABLED};
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 16448);
        description.setFont(description.getFont());
        description.setText(PreferencesMessages.ProblemSeveritiesConfigurationBlock_common_description);
        description.setLayoutData((Object)new GridData(1, 2, true, false, nColumns - 1, 1));
        int indentStep = this.fPixelConverter.convertWidthInCharsToPixels(1);
        int defaultIndent = indentStep * 0;
        Map<String, String> categories = ProblemSeveritiesConfigurationBlock.getErrorCategories();
        for (String categoryId : categories.keySet()) {
            List<Error> errors = ProblemSeveritiesConfigurationBlock.getErrors(categoryId);
            if (errors == null || errors.isEmpty()) continue;
            ExpandableComposite excomposite = this.createStyleSection(composite, categories.get(categoryId), nColumns);
            Composite inner = new Composite((Composite)excomposite, 0);
            inner.setFont(composite.getFont());
            inner.setLayout((Layout)new GridLayout(nColumns, false));
            excomposite.setClient((Control)inner);
            for (Error error : errors) {
                this.addComboBox(inner, String.valueOf(error.label) + ':', ProblemSeveritiesConfigurationBlock.getKey(error.getContributor(), error.getId()), errorWarningIgnore, errorWarningIgnoreLabels, defaultIndent);
                if (!error.hasArgument()) continue;
                Text text = this.addTextField(inner, "", ProblemSeveritiesConfigurationBlock.getKey(error.getContributor(), error.getArgument()), 0, 0);
                GridData gd = (GridData)text.getLayoutData();
                gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(8);
                gd.horizontalAlignment = 3;
                text.setTextLimit(6);
            }
        }
        IDialogSettings section = RubyPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        this.restoreSectionExpansionStates(section);
        return sc1;
    }

    private static List<Error> getErrors(String categoryId) {
        if (fgErrors == null) {
            fgErrors = new HashMap();
        }
        if (fgErrors.get(categoryId) != null) {
            return fgErrors.get(categoryId);
        }
        ArrayList<Error> categories = new ArrayList<Error>();
        List<IConfigurationElement> configElements = ProblemSeveritiesConfigurationBlock.getErrorProviderElements();
        for (IConfigurationElement configElement : configElements) {
            String name = configElement.getName();
            if (!name.equals(ERROR) || !configElement.getAttribute("categoryId").equals(categoryId)) continue;
            categories.add(new Error(configElement));
        }
        fgErrors.put(categoryId, categories);
        return categories;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            List<Error> errors = ProblemSeveritiesConfigurationBlock.getErrors();
            for (Error error : errors) {
                if (!error.hasArgument() || !error.argumentIsInt() || !changedKey.getName().equals(error.getArgument())) continue;
                this.fStatus = this.validateMaxNumber(changedKey, error.getLabel());
                this.fContext.statusChanged(this.fStatus);
                return;
            }
        } else {
            this.updateEnableStates();
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fStatus});
        this.fContext.statusChanged(status);
    }

    private static List<Error> getErrors() {
        ArrayList<Error> errors = new ArrayList<Error>();
        Map<String, String> categories = ProblemSeveritiesConfigurationBlock.getErrorCategories();
        for (String categoryId : categories.keySet()) {
            errors.addAll(ProblemSeveritiesConfigurationBlock.getErrors(categoryId));
        }
        return errors;
    }

    private IStatus validateMaxNumber(OptionsConfigurationBlock.Key key, String label) {
        String number = this.getValue(key);
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.RubyBuildConfigurationBlock_empty_input);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value <= 0) {
                    status.setError(Messages.format(PreferencesMessages.RubyBuildConfigurationBlock_invalid_input, new Object[]{number, label}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(Messages.format(PreferencesMessages.RubyBuildConfigurationBlock_invalid_input, new Object[]{number, label}));
            }
        }
        return status;
    }

    private void updateEnableStates() {
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.ProblemSeveritiesConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PreferencesMessages.ProblemSeveritiesConfigurationBlock_needsfullbuild_message : PreferencesMessages.ProblemSeveritiesConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    @Override
    public void dispose() {
        IDialogSettings section = RubyPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION_NAME);
        this.storeSectionExpansionStates(section);
        super.dispose();
    }

    private static class Error {
        private String id;
        private String label;
        private String contributor;
        private String argument;
        private String type;

        Error(IConfigurationElement element) {
            this.id = element.getAttribute("prefKey");
            this.label = element.getAttribute("label");
            this.contributor = element.getContributor().getName();
            IConfigurationElement[] elements = element.getChildren("argument");
            if (elements != null && elements.length > 0) {
                this.argument = elements[0].getAttribute("prefKey");
                this.type = elements[0].getAttribute("type");
                if (this.type == null) {
                    this.type = "int";
                }
            }
        }

        public boolean hasArgument() {
            return this.argument != null;
        }

        public String getContributor() {
            return this.contributor;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getArgument() {
            return this.argument;
        }

        public boolean argumentIsInt() {
            return this.hasArgument() && this.type.equals("int");
        }
    }
}

