/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.launching.RubyRuntime;

public class NewRubyProjectPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.rubypeople.rdt.ui.preferences.BuildPathPreferencePage";
    private static final String SRCBIN_FOLDERS_IN_NEWPROJ = "org.rubypeople.rdt.ui.wizards.srcFoldersInNewProjects";
    private static final String SRCBIN_SRCNAME = "org.rubypeople.rdt.ui.wizards.srcFoldersSrcName";
    private static final String LOADPATH_JRELIBRARY_INDEX = "org.rubypeople.rdt.ui.wizards.rubyvm.index";
    private static final String LOADPATH_JRELIBRARY_LIST = "org.rubypeople.rdt.ui.wizards.rubyvm.list";
    private static String fgDefaultEncoding = System.getProperty("file.encoding");
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;
    private SelectionListener fSelectionListener;
    private ModifyListener fModifyListener;
    private Text fSrcFolderNameText;
    private Combo fJRECombo;
    private Button fProjectAsSourceFolder;
    private Button fFoldersAsSourceFolder;
    private Label fSrcFolderNameLabel;

    public static ILoadpathEntry[] getDefaultJRELibrary() {
        ILoadpathEntry[] res;
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        String str = store.getString(LOADPATH_JRELIBRARY_LIST);
        int index = store.getInt(LOADPATH_JRELIBRARY_INDEX);
        StringTokenizer tok = new StringTokenizer(str, ";");
        while (tok.hasMoreTokens() && index > 0) {
            tok.nextToken();
            --index;
        }
        if (tok.hasMoreTokens() && (res = NewRubyProjectPreferencePage.decodeJRELibraryLoadpathEntries(tok.nextToken())).length > 0) {
            return res;
        }
        return new ILoadpathEntry[]{NewRubyProjectPreferencePage.getJREContainerEntry()};
    }

    public static String decodeJRELibraryDescription(String encoded) {
        int end = encoded.indexOf(32);
        if (end != -1) {
            return NewRubyProjectPreferencePage.decode(encoded.substring(0, end));
        }
        return "";
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            RubyPlugin.log(e);
            return "";
        }
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            RubyPlugin.log(e);
            return "";
        }
    }

    public static ILoadpathEntry[] decodeJRELibraryLoadpathEntries(String encoded) {
        StringTokenizer tok = new StringTokenizer(encoded, " ");
        ArrayList<ILoadpathEntry> res = new ArrayList<ILoadpathEntry>();
        while (tok.hasMoreTokens()) {
            String message;
            try {
                tok.nextToken();
                int kind = Integer.parseInt(tok.nextToken());
                IPath path = NewRubyProjectPreferencePage.decodePath(tok.nextToken());
                boolean isExported = Boolean.valueOf(tok.nextToken());
                switch (kind) {
                    case 3: {
                        res.add(RubyCore.newSourceEntry((IPath)path));
                        break;
                    }
                    case 1: {
                        res.add(RubyCore.newLibraryEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 4: {
                        res.add(RubyCore.newVariableEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 2: {
                        res.add(RubyCore.newProjectEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 5: {
                        res.add(RubyCore.newContainerEntry((IPath)path, (boolean)isExported));
                    }
                }
            }
            catch (NumberFormatException e) {
                message = PreferencesMessages.NewRubyProjectPreferencePage_error_decode;
                RubyPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, message, (Throwable)e));
            }
            catch (NoSuchElementException e) {
                message = PreferencesMessages.NewRubyProjectPreferencePage_error_decode;
                RubyPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, message, (Throwable)e));
            }
        }
        return res.toArray(new ILoadpathEntry[res.size()]);
    }

    public static String encodeJRELibrary(String desc, ILoadpathEntry[] cpentries) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cpentries.length) {
            ILoadpathEntry entry = cpentries[i];
            buf.append(NewRubyProjectPreferencePage.encode(desc));
            buf.append(' ');
            buf.append(entry.getEntryKind());
            buf.append(' ');
            buf.append(NewRubyProjectPreferencePage.encodePath(entry.getPath()));
            buf.append(' ');
            buf.append(entry.isExported());
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static String encodePath(IPath path) {
        if (path == null) {
            return "#";
        }
        if (path.isEmpty()) {
            return "&";
        }
        return NewRubyProjectPreferencePage.encode(path.toPortableString());
    }

    private static IPath decodePath(String str) {
        if ("#".equals(str)) {
            return null;
        }
        if ("&".equals(str)) {
            return Path.EMPTY;
        }
        return Path.fromPortableString((String)NewRubyProjectPreferencePage.decode(str));
    }

    public NewRubyProjectPreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.NewRubyProjectPreferencePage_description);
        this.setTitle(PreferencesMessages.NewRubyProjectPreferencePage_title);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
        this.fSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewRubyProjectPreferencePage.this.controlChanged(e.widget);
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRubyProjectPreferencePage.this.controlModified(e.widget);
            }
        };
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(SRCBIN_FOLDERS_IN_NEWPROJ, false);
        store.setDefault(SRCBIN_SRCNAME, "src");
        store.setDefault(LOADPATH_JRELIBRARY_LIST, NewRubyProjectPreferencePage.getDefaultJRELibraries());
        store.setDefault(LOADPATH_JRELIBRARY_INDEX, 0);
    }

    private static String getDefaultJRELibraries() {
        StringBuffer buf = new StringBuffer();
        ILoadpathEntry cntentry = NewRubyProjectPreferencePage.getJREContainerEntry();
        buf.append(NewRubyProjectPreferencePage.encodeJRELibrary(PreferencesMessages.NewRubyProjectPreferencePage_jre_container_description, new ILoadpathEntry[]{cntentry}));
        buf.append(';');
        ILoadpathEntry varentry = NewRubyProjectPreferencePage.getJREVariableEntry();
        buf.append(NewRubyProjectPreferencePage.encodeJRELibrary(PreferencesMessages.NewRubyProjectPreferencePage_jre_variable_description, new ILoadpathEntry[]{varentry}));
        buf.append(';');
        return buf.toString();
    }

    private static ILoadpathEntry getJREContainerEntry() {
        return RubyCore.newContainerEntry((IPath)new Path(RubyRuntime.RUBY_CONTAINER));
    }

    private static ILoadpathEntry getJREVariableEntry() {
        return RubyCore.newVariableEntry((IPath)new Path("RUBY_LIB"));
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.rubypeople.rdt.ui.new_java_project_preference_page_context");
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, value});
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        this.fRadioButtons.add(button);
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setText(this.getPreferenceStore().getString(key));
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        this.fTextControls.add(text);
        return text;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group sourceFolderGroup = new Group(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        sourceFolderGroup.setLayout((Layout)layout);
        sourceFolderGroup.setLayoutData((Object)gd);
        sourceFolderGroup.setText(PreferencesMessages.NewRubyProjectPreferencePage_sourcefolder_label);
        int indent = 0;
        this.fProjectAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewRubyProjectPreferencePage_sourcefolder_project, SRCBIN_FOLDERS_IN_NEWPROJ, "false", indent);
        this.fProjectAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fFoldersAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, PreferencesMessages.NewRubyProjectPreferencePage_sourcefolder_folder, SRCBIN_FOLDERS_IN_NEWPROJ, "true", indent);
        this.fFoldersAsSourceFolder.addSelectionListener(this.fSelectionListener);
        indent = this.convertWidthInCharsToPixels(4);
        this.fSrcFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fSrcFolderNameLabel.setText(PreferencesMessages.NewRubyProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fSrcFolderNameLabel, SRCBIN_SRCNAME, indent);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        String[] jreNames = this.getJRENames();
        if (jreNames.length > 0) {
            Label jreSelectionLabel = new Label(result, 0);
            jreSelectionLabel.setText(PreferencesMessages.NewRubyProjectPreferencePage_jrelibrary_label);
            jreSelectionLabel.setLayoutData((Object)new GridData());
            int index = this.getPreferenceStore().getInt(LOADPATH_JRELIBRARY_INDEX);
            this.fJRECombo = new Combo(result, 8);
            this.fJRECombo.setItems(jreNames);
            this.fJRECombo.select(index);
            this.fJRECombo.setLayoutData((Object)new GridData(256));
        }
        this.validateFolders();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void validateFolders() {
        boolean useFolders = this.fFoldersAsSourceFolder.getSelection();
        this.fSrcFolderNameText.setEnabled(useFolders);
        this.fSrcFolderNameLabel.setEnabled(useFolders);
        if (useFolders) {
            IStatus status;
            String srcName = this.fSrcFolderNameText.getText();
            if (srcName.length() == 0) {
                this.updateStatus(new StatusInfo(4, PreferencesMessages.NewRubyProjectPreferencePage_folders_error_namesempty));
                return;
            }
            IWorkspace workspace = RubyPlugin.getWorkspace();
            IProject dmy = workspace.getRoot().getProject("project");
            IPath srcPath = dmy.getFullPath().append(srcName);
            if (srcName.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
                String message = Messages.format((String)PreferencesMessages.NewRubyProjectPreferencePage_folders_error_invalidsrcname, (String)status.getMessage());
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
            ILoadpathEntry entry = RubyCore.newSourceEntry((IPath)srcPath);
            status = RubyConventions.validateLoadpath((IRubyProject)RubyCore.create((IProject)dmy), (ILoadpathEntry[])new ILoadpathEntry[]{entry}, null);
            if (!status.isOK()) {
                String message = PreferencesMessages.NewRubyProjectPreferencePage_folders_error_invalidcp;
                this.updateStatus(new StatusInfo(4, message));
                return;
            }
        }
        this.updateStatus(new StatusInfo());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void controlChanged(Widget widget) {
        if (widget == this.fFoldersAsSourceFolder || widget == this.fProjectAsSourceFolder) {
            this.validateFolders();
        }
    }

    private void controlModified(Widget widget) {
        if (widget == this.fSrcFolderNameText) {
            this.validateFolders();
        }
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        if (this.fJRECombo != null) {
            this.fJRECombo.select(store.getDefaultInt(LOADPATH_JRELIBRARY_INDEX));
        }
        this.validateFolders();
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        if (this.fJRECombo != null) {
            store.setValue(LOADPATH_JRELIBRARY_INDEX, this.fJRECombo.getSelectionIndex());
        }
        RubyPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private String[] getJRENames() {
        String prefString = this.getPreferenceStore().getString(LOADPATH_JRELIBRARY_LIST);
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(prefString, ";");
        while (tok.hasMoreTokens()) {
            list.add(NewRubyProjectPreferencePage.decodeJRELibraryDescription(tok.nextToken()));
        }
        return list.toArray(new String[list.size()]);
    }
}

