/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.Separator;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_METHOD_PARAMETER_NAMES = "org.rubypeople.rdt.ui.methodparameternames";
    private static final String STACK_BROWSING_VIEWS_VERTICALLY = "org.rubypeople.rdt.ui.browsing.stackVertically";
    public static final String PREF_COLORED_LABELS = "colored_labels_in_views";
    private SelectionButtonDialogField fStackBrowsingViewsVertically;
    private SelectionButtonDialogField fShowMethodParameterNames;

    public AppearancePreferencePage() {
        this.setPreferenceStore(RubyPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.AppearancePreferencePage_description);
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AppearancePreferencePage.this.doDialogFieldChanged(field);
            }
        };
        this.fShowMethodParameterNames = new SelectionButtonDialogField(32);
        this.fShowMethodParameterNames.setDialogFieldListener(listener);
        this.fShowMethodParameterNames.setLabelText(PreferencesMessages.AppearancePreferencePage_methodtypeparams_label);
        this.fStackBrowsingViewsVertically = new SelectionButtonDialogField(32);
        this.fStackBrowsingViewsVertically.setDialogFieldListener(listener);
        this.fStackBrowsingViewsVertically.setLabelText(PreferencesMessages.AppearancePreferencePage_stackViewsVerticallyInTheRubyBrowsingPerspective);
    }

    private void initFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowMethodParameterNames.setSelection(prefs.getBoolean(PREF_METHOD_PARAMETER_NAMES));
        this.fStackBrowsingViewsVertically.setSelection(prefs.getBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.rubypeople.rdt.ui.appearance_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 1;
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        result.setLayout((Layout)layout);
        this.fShowMethodParameterNames.doFillIntoGrid(result, nColumns);
        new Separator().doFillIntoGrid(result, nColumns);
        this.fStackBrowsingViewsVertically.doFillIntoGrid(result, nColumns);
        String noteTitle = PreferencesMessages.AppearancePreferencePage_note;
        String noteMessage = PreferencesMessages.AppearancePreferencePage_preferenceOnlyEffectiveForNewPerspectives;
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), result, noteTitle, noteMessage);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        noteControl.setLayoutData((Object)gd);
        this.initFields();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void doDialogFieldChanged(DialogField field) {
        this.updateStatus(this.getValidationStatus());
    }

    private IStatus getValidationStatus() {
        return new StatusInfo();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue(PREF_METHOD_PARAMETER_NAMES, this.fShowMethodParameterNames.isSelected());
        prefs.setValue(STACK_BROWSING_VIEWS_VERTICALLY, this.fStackBrowsingViewsVertically.isSelected());
        RubyPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowMethodParameterNames.setSelection(prefs.getDefaultBoolean(PREF_METHOD_PARAMETER_NAMES));
        this.fStackBrowsingViewsVertically.setSelection(prefs.getDefaultBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
        super.performDefaults();
    }
}

