/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        List resources = this.convertSelection();
        event.data = resources.toArray(new IResource[resources.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
    }

    private List convertSelection() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        ArrayList result = new ArrayList(selection.size());
        for (Object element : selection) {
            if (!(element instanceof IResource)) continue;
            result.add(element);
        }
        return result;
    }
}

