/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.packageview.SourceFolderProvider;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetModel;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;

public class PackageExplorerContentProvider
extends StandardRubyElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout;
    private SourceFolderProvider fSourceFolderProvider = new SourceFolderProvider();
    private int fPendingChanges;

    public PackageExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    SourceFolderProvider getSourceFolderProvider() {
        return this.fSourceFolderProvider;
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (this.inputDeleted()) {
                return;
            }
            this.processDelta(event.getDelta());
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    private boolean inputDeleted() {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IRubyElement && ((IRubyElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput);
        return true;
    }

    public void dispose() {
        super.dispose();
        RubyCore.removeElementChangedListener((IElementChangedListener)this);
        this.fSourceFolderProvider.dispose();
    }

    private boolean needsToDelegateGetChildren(Object element) {
        int type = -1;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            return RubyProject.hasRubyNature((IProject)folder.getProject());
        }
        if (element instanceof IRubyElement) {
            type = ((IRubyElement)element).getElementType();
        }
        return !this.fIsFlatLayout && (type == 3 || type == 2 || type == 1);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        try {
            if (parentElement instanceof IRubyModel) {
                return PackageExplorerContentProvider.concatenate(this.getRubyProjects((IRubyModel)parentElement), this.getNonRubyProjects((IRubyModel)parentElement));
            }
            if (parentElement instanceof LoadPathContainer) {
                return this.getContainerSourceFolderRoots((LoadPathContainer)parentElement);
            }
            if (parentElement instanceof IProject) {
                return ((IProject)parentElement).members();
            }
            if (this.needsToDelegateGetChildren(parentElement)) {
                Object[] packageFragments = this.fSourceFolderProvider.getChildren(parentElement);
                children = this.getWithParentsResources(packageFragments, parentElement);
            } else {
                children = super.getChildren(parentElement);
            }
            if (parentElement instanceof IRubyProject) {
                IRubyProject project = (IRubyProject)parentElement;
                return this.rootsAndContainers(project, children);
            }
            return children;
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] rootsAndContainers(IRubyProject project, Object[] roots) throws RubyModelException {
        ArrayList<Object> result = new ArrayList<Object>(roots.length);
        HashSet<ILoadpathEntry> containers = new HashSet<ILoadpathEntry>(roots.length);
        HashSet containedRoots = new HashSet(roots.length);
        ILoadpathEntry[] entries = project.getRawLoadpath();
        int i = 0;
        while (i < entries.length) {
            ILoadpathEntry entry = entries[i];
            if (entry != null && entry.getEntryKind() == 5) {
                ISourceFolderRoot[] roots1 = project.findSourceFolderRoots(entry);
                containedRoots.addAll(Arrays.asList(roots1));
                containers.add(entry);
            }
            ++i;
        }
        i = 0;
        while (i < roots.length) {
            if (roots[i] instanceof ISourceFolderRoot) {
                if (!containedRoots.contains(roots[i])) {
                    result.add(roots[i]);
                }
            } else {
                result.add(roots[i]);
            }
            ++i;
        }
        for (ILoadpathEntry element : containers) {
            result.add(new LoadPathContainer(project, element));
        }
        return result.toArray();
    }

    private Object[] getContainerSourceFolderRoots(LoadPathContainer container) {
        return container.getChildren(container);
    }

    private Object[] getNonRubyProjects(IRubyModel model) throws RubyModelException {
        return model.getNonRubyResources();
    }

    public Object getParent(Object child) {
        if (this.needsToDelegateGetParent(child)) {
            return this.fSourceFolderProvider.getParent(child);
        }
        return super.getParent(child);
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof ISourceFolderRoot) {
            ISourceFolderRoot root = (ISourceFolderRoot)element;
            IRubyProject project = root.getRubyProject();
            try {
                ILoadpathEntry[] entries = project.getRawLoadpath();
                int i = 0;
                while (i < entries.length) {
                    ILoadpathEntry entry = entries[i];
                    if (entry.getEntryKind() == 5 && LoadPathContainer.contains(project, entry, root)) {
                        return new LoadPathContainer(project, entry);
                    }
                    ++i;
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        if (element instanceof LoadPathContainer) {
            return ((LoadPathContainer)element).getRubyProject();
        }
        return super.internalGetParent(element);
    }

    private boolean needsToDelegateGetParent(Object element) {
        int type = -1;
        if (element instanceof IRubyElement) {
            type = ((IRubyElement)element).getElementType();
        }
        return !this.fIsFlatLayout && type == 3;
    }

    private Object[] getWithParentsResources(Object[] existingObject, Object parent) {
        Object[] objects = super.getChildren(parent);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (!(object instanceof ISourceFolder) && !list.contains(object)) {
                list.add(object);
            }
            ++i;
        }
        if (existingObject != null) {
            list.addAll((Collection)Arrays.asList(existingObject));
        }
        return list.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fSourceFolderProvider.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            RubyCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            RubyCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void processDelta(IRubyElementDelta delta) throws RubyModelException {
        Object parent;
        IRubyProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IRubyElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 0 || elementType == 1 || (proj = element.getRubyProject()) != null && proj.getProject().isOpen())) {
            return;
        }
        if (!this.fIsFlatLayout && elementType == 3) {
            this.fSourceFolderProvider.processDelta(delta);
            if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
                return;
            }
            this.handleAffectedChildren(delta, element);
            return;
        }
        if (elementType == 4) {
            IRubyScript cu = (IRubyScript)element;
            if (!RubyModelUtil.isPrimary(cu)) {
                return;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return;
            }
            if (kind == 4 && !PackageExplorerContentProvider.isStructuralCUChange(flags)) {
                return;
            }
            if (!this.isOnClassPath(cu)) {
                return;
            }
        }
        if (elementType == 1) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            if (element instanceof ISourceFolder) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            this.postRemove(element);
            if (parent instanceof ISourceFolder) {
                this.postUpdateIcon((IRubyElement)((ISourceFolder)parent));
            }
            if (this.isSourceFolderEmpty(element.getParent()) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(this.internalGetParent(parent), 2, element);
            }
            return;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof ISourceFolder) {
                Object grandparent = this.internalGetParent(parent);
                if (((ISourceFolder)parent).isDefaultPackage()) {
                    parent = grandparent;
                    grandparent = this.internalGetParent(parent);
                }
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            if ((flags & 0x10) != 0) {
                this.postRemove(delta.getMovedFromElement());
            }
            this.postAdd(parent, element);
        }
        if (elementType == 4) {
            if (kind == 4) {
                this.postRefresh(element, 0, element);
                this.updateSelection(delta);
            }
            return;
        }
        if (elementType == 2) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if ((flags & 0x3000) != 0) {
                this.postUpdateIcon(element);
            }
            if (this.isClassPathChange(delta)) {
                this.postRefresh(element.getRubyProject(), 4, element);
                return;
            }
        }
        if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
            return;
        }
        this.handleAffectedChildren(delta, element);
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IRubyElementDelta delta, IRubyElement element) throws RubyModelException {
        IRubyElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (affectedChildren.length > 1) {
            if (element instanceof ISourceFolder) {
                IRubyElement parent = (IRubyElement)this.internalGetParent(element);
                if (parent instanceof ISourceFolderRoot) {
                    parent = (IRubyElement)this.internalGetParent(parent);
                }
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            if (element instanceof ISourceFolderRoot) {
                Object toRefresh = this.skipProjectSourceFolderRoot((ISourceFolderRoot)element);
                this.postRefresh(toRefresh, 0, toRefresh);
            } else {
                this.postRefresh(element, 0, element);
            }
            return;
        }
        this.processAffectedChildren(affectedChildren);
    }

    protected void processAffectedChildren(IRubyElementDelta[] affectedChildren) throws RubyModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnClassPath(IRubyScript element) {
        IRubyProject project = element.getRubyProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnLoadpath((IRubyElement)element);
    }

    private void updateSelection(IRubyElementDelta delta) {
        final IRubyElement addedElement = this.findAddedElement(delta);
        if (addedElement != null) {
            final StructuredSelection selection = new StructuredSelection((Object)addedElement);
            this.postRunnable(new Runnable(){

                public void run() {
                    Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                    if (ctrl != null && !ctrl.isDisposed() && PackageExplorerContentProvider.this.fViewer.testFindItem((Object)addedElement) != null) {
                        PackageExplorerContentProvider.this.fViewer.setSelection((ISelection)selection);
                    }
                }
            });
        }
    }

    private IRubyElement findAddedElement(IRubyElementDelta delta) {
        if (delta.getKind() == 1) {
            return delta.getElement();
        }
        int i = 0;
        IRubyElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (i < affectedChildren.length) {
            return this.findAddedElement(affectedChildren[i]);
        }
        return null;
    }

    private void postUpdateIcon(final IRubyElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof ISourceFolder) {
                Object grandparent = this.internalGetParent(parent);
                if (grandparent instanceof ISourceFolderRoot && ((ISourceFolderRoot)grandparent).getResource().equals((Object)((ISourceFolderRoot)grandparent).getRubyProject().getProject())) {
                    parent = grandparent;
                    grandparent = this.internalGetParent(parent);
                }
                this.postRefresh(grandparent, 1, parent);
                return true;
            }
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            if (parent instanceof ISourceFolder) {
                Object grandparent = this.internalGetParent(parent);
                if (grandparent instanceof ISourceFolderRoot && ((ISourceFolderRoot)grandparent).getResource().equals((Object)((ISourceFolderRoot)grandparent).getRubyProject().getProject())) {
                    parent = grandparent;
                    grandparent = this.internalGetParent(parent);
                }
                this.postRefresh(grandparent, 1, parent);
                return true;
            }
            this.postAdd(parent, resource);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent));
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (deltas.length > 1) {
            this.postRefresh(parent, 0, parent);
            return true;
        }
        int i = 0;
        while (i < deltas.length) {
            if (this.processResourceDelta(deltas[i], parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void postRefresh(Object root, int relation, Object affectedElement) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        PackageExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                    }
                }
            }
        });
    }

    protected void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && PackageExplorerContentProvider.this.fViewer.testFindItem(element) == null) {
                    PackageExplorerContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    protected void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    protected void postProjectStateChanged(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackageExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    PackageExplorerContentProvider.this.fViewer.refresh(root, true);
                    PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
                }
            }
        });
    }

    void postRunnable(final Runnable r) {
        Control ctrl = this.fViewer.getControl();
        Runnable trackedRunnable = new Runnable(){

            public void run() {
                try {
                    r.run();
                }
                finally {
                    PackageExplorerContentProvider.this.removePendingChange();
                }
            }
        };
        if (ctrl != null && !ctrl.isDisposed()) {
            this.addPendingChange();
            try {
                ctrl.getDisplay().asyncExec(trackedRunnable);
            }
            catch (RuntimeException e) {
                this.removePendingChange();
                throw e;
            }
            catch (Error e) {
                this.removePendingChange();
                throw e;
            }
        }
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }
}

