/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.packageview.PackagesMessages;

public class LoadPathContainer
implements IAdaptable,
IWorkbenchAdapter {
    private IRubyProject fProject;
    private ILoadpathEntry fClassPathEntry;
    private ILoadpathContainer fContainer;

    public LoadPathContainer(IRubyProject parent, ILoadpathEntry entry) {
        this.fProject = parent;
        this.fClassPathEntry = entry;
        try {
            this.fContainer = RubyCore.getLoadpathContainer((IPath)entry.getPath(), (IRubyProject)parent);
        }
        catch (RubyModelException rubyModelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LoadPathContainer) {
            LoadPathContainer other = (LoadPathContainer)obj;
            if (this.fProject.equals(other.fProject) && this.fClassPathEntry.equals(other.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fProject.hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    public Object[] getSourceFolderRoots() {
        return this.fProject.findSourceFolderRoots(this.fClassPathEntry);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IResource.class && this.fContainer instanceof IAdaptable) {
            return ((IAdaptable)this.fContainer).getAdapter(IResource.class);
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return LoadPathContainer.concatenate(this.getSourceFolderRoots(), this.getRequiredProjects());
    }

    private Object[] getRequiredProjects() {
        ArrayList<RequiredProjectWrapper> list = new ArrayList<RequiredProjectWrapper>();
        if (this.fContainer != null) {
            ILoadpathEntry[] classpathEntries = this.fContainer.getLoadpathEntries();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < classpathEntries.length) {
                IResource resource;
                ILoadpathEntry entry = classpathEntries[i];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                    list.add(new RequiredProjectWrapper(RubyCore.create((IResource)resource)));
                }
                ++i;
            }
        }
        return list.toArray();
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return RubyPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fClassPathEntry.getPath();
        String containerId = path.segment(0);
        LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.fProject);
            return Messages.format(PackagesMessages.ClassPathContainer_unbound_label, description);
        }
        return Messages.format(PackagesMessages.ClassPathContainer_unknown_label, path.toString());
    }

    public Object getParent(Object o) {
        return this.getRubyProject();
    }

    public IRubyProject getRubyProject() {
        return this.fProject;
    }

    public ILoadpathEntry getLoadpathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IRubyProject project, ILoadpathEntry entry, ISourceFolderRoot root) {
        ISourceFolderRoot[] roots = project.findSourceFolderRoots(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final IRubyElement fProject;
        private static ImageDescriptor DESC_OBJ_PROJECT;

        public RequiredProjectWrapper(IRubyElement project) {
            ISharedImages images = RubyPlugin.getDefault().getWorkbench().getSharedImages();
            DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
            this.fProject = project;
        }

        public IRubyElement getProject() {
            return this.fProject;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return DESC_OBJ_PROJECT;
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

