/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.corext.util.Resources;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.packageview.PackagesMessages;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

class FileTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;

    FileTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.isDragable(this.fProvider.getSelection());
    }

    private boolean isDragable(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        for (Object element : selection) {
            if (!(element instanceof IRubyElement)) continue;
            IRubyElement jElement = (IRubyElement)element;
            int type = jElement.getElementType();
            if (type != 2 && type != 4 && type != 5) {
                return false;
            }
            ISourceFolderRoot root = (ISourceFolderRoot)jElement.getAncestor(2);
            if (root == null || !root.isArchive()) continue;
            return false;
        }
        List resources = this.convertIntoResources(selection);
        return resources.size() == selection.size();
    }

    public void dragSetData(DragSourceEvent event) {
        List elements = this.getResources();
        if (elements == null || elements.size() == 0) {
            event.data = null;
            return;
        }
        event.data = FileTransferDragAdapter.getResourceLocations(elements);
    }

    private static String[] getResourceLocations(List resources) {
        return Resources.getLocationOSStrings(resources.toArray(new IResource[resources.size()]));
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail != 2 && (event.detail == 0 || event.detail == 8)) {
            this.handleRefresh(event);
        }
    }

    void handleDropMove(DragSourceEvent event) {
        final List elements = this.getResources();
        if (elements == null || elements.size() == 0) {
            return;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(PackagesMessages.DragAdapter_deleting, elements.size());
                    MultiStatus status = FileTransferDragAdapter.this.createMultiStatus();
                    for (IResource resource : elements) {
                        try {
                            try {
                                monitor.subTask(resource.getFullPath().toOSString());
                                resource.delete(true, null);
                            }
                            catch (CoreException e) {
                                status.add(e.getStatus());
                                monitor.worked(1);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            throw throwable;
                        }
                        monitor.worked(1);
                    }
                    if (!status.isOK()) {
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.runOperation((IRunnableWithProgress)op, true, false);
    }

    private void handleRefresh(DragSourceEvent event) {
        final Set roots = this.collectRoots(this.getResources());
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(PackagesMessages.DragAdapter_refreshing, roots.size());
                    MultiStatus status = FileTransferDragAdapter.this.createMultiStatus();
                    for (IResource r : roots) {
                        try {
                            r.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                    if (!status.isOK()) {
                        throw new CoreException((IStatus)status);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.runOperation((IRunnableWithProgress)op, true, false);
    }

    protected Set collectRoots(List elements) {
        HashSet<Object> roots = new HashSet<Object>(10);
        for (IResource resource : elements) {
            IContainer parent = resource.getParent();
            if (parent == null) {
                roots.add(resource);
                continue;
            }
            roots.add(parent);
        }
        return roots;
    }

    private List getResources() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        return this.convertIntoResources((IStructuredSelection)s);
    }

    private List convertIntoResources(IStructuredSelection selection) {
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        for (Object o : selection) {
            IResource r = null;
            if (o instanceof IResource) {
                r = (IResource)o;
            } else if (o instanceof IAdaptable) {
                r = (IResource)((IAdaptable)o).getAdapter(IResource.class);
            }
            if (r == null || r.getLocation() == null) continue;
            result.add(r);
        }
        return result;
    }

    private MultiStatus createMultiStatus() {
        return new MultiStatus(RubyPlugin.getPluginId(), 0, PackagesMessages.DragAdapter_problem, null);
    }

    private void runOperation(IRunnableWithProgress op, boolean fork, boolean cancelable) {
        try {
            Shell parent = RubyPlugin.getActiveWorkbenchShell();
            new ProgressMonitorDialog(parent).run(fork, cancelable, op);
        }
        catch (InvocationTargetException e) {
            String message = PackagesMessages.DragAdapter_problem;
            String title = PackagesMessages.DragAdapter_problemTitle;
            ExceptionHandler.handle(e, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }
}

