/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.infoviews;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.core.ICodeAssist;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;

class TextSelectionConverter {
    private static final IRubyElement[] EMPTY_RESULT = new IRubyElement[0];

    private TextSelectionConverter() {
    }

    public static IRubyElement[] codeResolve(RubyEditor editor, ITextSelection selection) throws RubyModelException {
        return TextSelectionConverter.codeResolve(TextSelectionConverter.getInput(editor), selection);
    }

    public static IRubyElement getElementAtOffset(RubyEditor editor, ITextSelection selection) throws RubyModelException {
        return TextSelectionConverter.getElementAtOffset(TextSelectionConverter.getInput(editor), selection);
    }

    private static IRubyElement getInput(RubyEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    private static IRubyElement[] codeResolve(IRubyElement input, ITextSelection selection) throws RubyModelException {
        if (input instanceof ICodeAssist) {
            IRubyElement[] elements;
            IRubyScript cunit;
            if (input instanceof IRubyScript && (cunit = (IRubyScript)input).isWorkingCopy()) {
                RubyModelUtil.reconcile(cunit);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    private static IRubyElement getElementAtOffset(IRubyElement input, ITextSelection selection) throws RubyModelException {
        if (input instanceof IRubyScript) {
            IRubyElement ref;
            IRubyScript cunit = (IRubyScript)input;
            if (cunit.isWorkingCopy()) {
                RubyModelUtil.reconcile(cunit);
            }
            if ((ref = cunit.getElementAt(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

