/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.infoviews;

import com.aptana.rdt.AptanaRDTPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.rubypeople.rdt.core.IRubyInformation;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.infoviews.FastRIParser;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.ui.text.ansi.ANSIParser;
import org.rubypeople.rdt.ui.text.ansi.ANSIToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiUtility
implements IRubyInformation {
    private static final String HEADER = "<html><head></head><body>";
    private static final String TAIL = "</body></html>";
    private static final String FASTRI_INDEX = ".fastri-index";

    public String getDocs(String token) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(token);
        return RiUtility.getRIContents(args);
    }

    public static String getRIContents(List<String> args) {
        File file = RiUtility.getFRIIndexFile();
        if (!file.exists()) {
            RiUtility.buildIndex();
        }
        args.add(0, "-L");
        return RiUtility.execAndReadOutput(RiUtility.getFastRiPath(), args);
    }

    public static String getRIHTMLContents(List<String> args) {
        String result = RiUtility.getRIContents(args);
        if (result == null) {
            return result;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(RiUtility.checkForANSIColors(RiUtility.escapeHTML(result)));
        buffer.insert(0, HEADER);
        buffer.append(TAIL);
        return buffer.toString();
    }

    private static String checkForANSIColors(String string) {
        StringBuilder buffer = new StringBuilder();
        List<ANSIToken> tokens = RiUtility.getParser(string).parse(string);
        for (ANSIToken token : tokens) {
            String endTag = "";
            if (token.hasFontStyle()) {
                if (token.getFontStyle() == 1) {
                    buffer.append("<b>");
                    endTag = "</b>";
                } else if (token.getFontStyle() == 2) {
                    buffer.append("<i>");
                    endTag = "</i>";
                }
            }
            if (token.hasForegroundColor()) {
                buffer.append("<span style=\"color: #");
                buffer.append(RiUtility.pad(Integer.toHexString(token.getForegroundRGB().red)));
                buffer.append(RiUtility.pad(Integer.toHexString(token.getForegroundRGB().green)));
                buffer.append(RiUtility.pad(Integer.toHexString(token.getForegroundRGB().blue)));
                buffer.append("\">");
                endTag = "</span>" + endTag;
            }
            buffer.append(token.toString());
            buffer.append(endTag);
        }
        return buffer.toString();
    }

    private static ANSIParser getParser(String content) {
        if (content.indexOf(27) != -1) {
            return new ANSIParser();
        }
        if (Platform.getOS().equals("win32") && !RubyRuntime.currentVMIsCygwin() && !RubyRuntime.currentVMIsJRuby()) {
            return new FastRIParser();
        }
        return new ANSIParser();
    }

    private static String pad(String hexString) {
        if (hexString.length() == 1) {
            return "0" + hexString;
        }
        return hexString;
    }

    private static String escapeHTML(String content) {
        String escaped = content.replace("&", "&amp;");
        escaped = escaped.replace("<", "&lt;");
        escaped = escaped.replace(">", "&gt;");
        escaped = escaped.replace("\r\n", "\n");
        escaped = escaped.replace("\r", "\n");
        escaped = escaped.replace("\n", "<br/>");
        return escaped;
    }

    static void rebuildIndex() {
        File file = RiUtility.getFRIIndexFile();
        file.delete();
        RiUtility.buildIndex();
    }

    static void buildIndex() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-b");
        RiUtility.execAndReadOutput(RiUtility.getFastRiServerPath(), commands);
    }

    private static File getFRIIndexFile() {
        if (RubyRuntime.currentVMIsCygwin()) {
            return new File(RubyRuntime.getDefaultVMInstall().getInstallLocation(), FASTRI_INDEX);
        }
        String homePath = System.getProperty("user.home");
        return new File(String.valueOf(homePath) + File.separator + FASTRI_INDEX);
    }

    private static String getFastRiPath() {
        RiUtility.copyFastRIFiles();
        File file = LaunchingPlugin.getFileInPlugin((IPath)new Path("ruby/fri"));
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static void copyFastRIFiles() {
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("full_text_index.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("full_text_indexer.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("name_descriptor.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("ri_index.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("ri_service.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("util.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri").append("version.rb"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fri"));
        RubyCore.copyToStateLocation((Plugin)LaunchingPlugin.getDefault(), (IPath)new Path("ruby").append("fastri-server"));
    }

    private static String getFastRiServerPath() {
        RiUtility.copyFastRIFiles();
        File file = LaunchingPlugin.getFileInPlugin((IPath)new Path("ruby/fastri-server"));
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        return file.getAbsolutePath();
    }

    private static ILaunchConfigurationType getRubyApplicationConfigType() {
        return RiUtility.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private static synchronized String execAndReadOutput(String file, List<String> commands) {
        if (file == null || file.trim().length() == 0) {
            RubyPlugin.log(4, "Tried to execute commands against empty executable file for RIUtility: " + commands.toString());
            return "";
        }
        ILaunchConfiguration config = RiUtility.createConfiguration(file, RiUtility.listToCommandLine(commands));
        File output = RubyPlugin.getDefault().getStateLocation().append("fastri_output.txt").toFile();
        return RiUtility.launchInBackgroundAndRead(config, output);
    }

    private static String listToCommandLine(List<String> commands) {
        String arguments = "";
        for (String command : commands) {
            arguments = String.valueOf(arguments) + command;
            arguments = String.valueOf(arguments) + " ";
        }
        if (arguments.length() > 0) {
            arguments = arguments.substring(0, arguments.length() - 1);
        }
        return arguments;
    }

    private static ILaunchConfiguration createConfiguration(String file, String arguments) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = RiUtility.getRubyApplicationConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, RiUtility.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(file));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, file);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, arguments);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, "ruby");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, LaunchingPlugin.getFileInPlugin((IPath)new Path("ruby")).getAbsolutePath());
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            config = wc.doSave();
        }
        catch (CoreException coreException) {}
        return config;
    }

    private static String launchInBackgroundAndRead(ILaunchConfiguration config, File file) {
        final StringBuffer buf = new StringBuffer();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", file.getAbsolutePath());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FORCE_NO_CONSOLE, true);
            config = wc.doSave();
            ILaunch launch = config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            IProcess iproc = launch.getProcesses()[0];
            IStreamMonitor stdOut = iproc.getStreamsProxy().getOutputStreamMonitor();
            stdOut.addListener(new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    buf.append(text);
                }
            });
            while (!launch.isTerminated()) {
                Thread.yield();
            }
            if (buf.toString().trim().length() == 0) {
                buf.append(RiUtility.readFile(file));
            }
            return buf.toString();
        }
        catch (Exception e) {
            AptanaRDTPlugin.log((Throwable)e);
            return null;
        }
    }

    private static String readFile(File file) {
        StringBuffer buf;
        block19: {
            buf = new StringBuffer();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                    buf.append("\n");
                }
            }
            catch (FileNotFoundException e) {
                AptanaRDTPlugin.log((Throwable)e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
            }
            catch (IOException e) {
                try {
                    AptanaRDTPlugin.log((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return buf.toString();
    }
}

