/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RDocUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.infoviews.AbstractInfoView;
import org.rubypeople.rdt.internal.ui.infoviews.InfoViewMessages;
import org.rubypeople.rdt.internal.ui.infoviews.TextSelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.text.HTMLPrinter;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;

public class RDocView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "RubydocView.error.doNotWarn";
    private static final boolean WARNING_DIALOG_ENABLED = false;
    private Browser fBrowser;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private static String fgStyleSheet;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;

    protected void internalCreatePartControl(Composite parent) {
        try {
            this.fBrowser = new Browser(parent, 0);
            this.fIsUsingBrowserWidget = true;
        }
        catch (SWTError sWTError) {
            IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
            store.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    RDocView.this.setInput(RDocView.this.fText.getText());
                }
            });
        }
        RDocView.initStyleSheet();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    private static void initStyleSheet() {
        Bundle bundle = Platform.getBundle((String)RubyPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/RDocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return;
        }
        try {
            styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(200);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            fgStyleSheet = buffer.toString();
        }
        catch (IOException ex) {
            RubyPlugin.log(ex);
        }
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
    }

    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
        if (this.getInput() == null) {
            StringBuffer buffer = new StringBuffer("");
            HTMLPrinter.insertPageProlog(buffer, 0, this.fBackgroundColorRGB, fgStyleSheet);
            this.setInput(buffer.toString());
        } else {
            this.setInput(this.computeInput(this.getInput()));
        }
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.jdt.ui.RubydocView.backgroundColor";
    }

    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    protected Object computeInput(Object input) {
        String javadocHtml;
        if (this.getControl() == null || !(input instanceof IRubyElement)) {
            return null;
        }
        IRubyElement je = (IRubyElement)input;
        switch (je.getElementType()) {
            case 4: {
                try {
                    javadocHtml = this.getRubydocHtml((IRubyElement[])((IRubyScript)je).getTypes());
                }
                catch (RubyModelException rubyModelException) {
                    javadocHtml = null;
                }
                break;
            }
            default: {
                javadocHtml = this.getRubydocHtml(new IRubyElement[]{je});
            }
        }
        if (javadocHtml == null) {
            return "";
        }
        return javadocHtml;
    }

    protected void setInput(Object input) {
        String javadocHtml = (String)input;
        if (this.fIsUsingBrowserWidget) {
            if (javadocHtml != null && javadocHtml.length() > 0) {
                boolean RTL;
                boolean bl = RTL = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (RTL) {
                    StringBuffer buffer = new StringBuffer(javadocHtml);
                    HTMLPrinter.insertStyles(buffer, new String[]{"direction:rtl"});
                    javadocHtml = buffer.toString();
                }
            }
            this.fBrowser.setText(javadocHtml);
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                javadocHtml = ((DefaultInformationControl.IInformationPresenterExtension)this.fPresenter).updatePresentation((Drawable)this.getSite().getShell(), javadocHtml, this.fPresentation, size.width, size.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(javadocHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getRubydocHtml(IRubyElement[] result) {
        StringBuffer buffer = new StringBuffer();
        String contents = RDocUtil.getHTMLDocumentation(result);
        if (contents != null) {
            buffer.append(contents);
        } else {
            HTMLPrinter.addParagraph(buffer, InfoViewMessages.RubydocView_noAttachedInformation);
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, this.fBackgroundColorRGB, fgStyleSheet);
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    protected boolean isIgnoringNewInput(IRubyElement je, IWorkbenchPart part, ISelection selection) {
        if (super.isIgnoringNewInput(je, part, selection) && part instanceof ITextEditor && selection instanceof ITextSelection) {
            ITextEditor editor = (ITextEditor)part;
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null) {
                return false;
            }
            IDocument document = docProvider.getDocument((Object)editor.getEditorInput());
            if (!(document instanceof IDocumentExtension3)) {
                return false;
            }
            try {
                int offset = ((ITextSelection)selection).getOffset();
                String partition = ((IDocumentExtension3)document).getContentType("___ruby_partitioning", offset, false);
                return partition != "__ruby_singleline_comment" && partition != "__ruby_multiline_comment";
            }
            catch (BadPartitioningException badPartitioningException) {
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    protected IRubyElement findSelectedRubyElement(IWorkbenchPart part, ISelection selection) {
        IRubyElement element;
        block7: {
            IDocument document;
            ITextSelection textSelection;
            block9: {
                IDocumentProvider documentProvider;
                RubyEditor editor;
                block8: {
                    element = super.findSelectedRubyElement(part, selection);
                    if (element != null || !(part instanceof RubyEditor) || !(selection instanceof ITextSelection)) break block7;
                    editor = (RubyEditor)part;
                    textSelection = (ITextSelection)selection;
                    documentProvider = editor.getDocumentProvider();
                    if (documentProvider != null) break block8;
                    return null;
                }
                document = documentProvider.getDocument((Object)editor.getEditorInput());
                if (document != null) break block9;
                return null;
            }
            ITypedRegion typedRegion = TextUtilities.getPartition((IDocument)document, (String)"___ruby_partitioning", (int)textSelection.getOffset(), (boolean)false);
            if ("__ruby_multiline_comment".equals(typedRegion.getType()) || "__ruby_singleline_comment".equals(typedRegion.getType())) {
                return TextSelectionConverter.getElementAtOffset((RubyEditor)part, textSelection);
            }
            return null;
        }
        try {
            return element;
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    protected String getHelpContextId() {
        return "org.rubypeople.rdt.ui.rdoc_view_context";
    }

    private class SelectAllAction
    extends Action {
        private Control fControl;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)control);
            Assert.isNotNull((Object)selectionProvider);
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!RDocView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList(1);
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SelectionProvider.this.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

