/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.compare;

import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.compare.RubyCompareUtilities;
import org.rubypeople.rdt.internal.ui.compare.RubyMergeViewer;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubyTextViewer
extends Viewer {
    private SourceViewer fSourceViewer;
    private Object fInput;

    RubyTextViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 0x2000300);
        RubyTextTools tools = RubyCompareUtilities.getRubyTextTools();
        if (tools != null) {
            IPreferenceStore store = RubyPlugin.getDefault().getCombinedPreferenceStore();
            this.fSourceViewer.configure((SourceViewerConfiguration)new RubySourceViewerConfiguration(tools.getColorManager(), store, null, "___ruby_partitioning"));
        }
        this.fSourceViewer.setEditable(false);
        String symbolicFontName = RubyMergeViewer.class.getName();
        Font font = JFaceResources.getFont((String)symbolicFontName);
        if (font != null) {
            this.fSourceViewer.getTextWidget().setFont(font);
        }
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(RubyTextViewer.getString(input));
            RubyCompareUtilities.setupDocument((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
        }
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s, boolean reveal) {
    }

    public void refresh() {
    }

    private static String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)input;
            try {
                return RubyCompareUtilities.readString(sca);
            }
            catch (CoreException ex) {
                RubyPlugin.log(ex);
            }
        }
        return "";
    }
}

