/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.compare.CompareMessages;
import org.rubypeople.rdt.internal.ui.compare.RubyCompareUtilities;

class RubyNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int SCRIPT = 0;
    public static final int IMPORT_CONTAINER = 2;
    public static final int IMPORT = 3;
    public static final int MODULE = 4;
    public static final int CLASS = 5;
    public static final int FIELD = 8;
    public static final int CONSTRUCTOR = 10;
    public static final int METHOD = 11;
    private int fInitializerCount = 1;
    private boolean fIsEditable;
    private RubyNode fParent;

    public RubyNode(RubyNode parent, int type, String name, int start, int length) {
        super(type, RubyCompareUtilities.buildID(type, name), parent.getDocument(), start, length);
        this.fParent = parent;
        if (parent != null) {
            parent.addChild(this);
            this.fIsEditable = parent.isEditable();
        }
    }

    public RubyNode(IDocument document, boolean editable) {
        super(0, RubyCompareUtilities.buildID(0, "root"), document, 0, document.getLength());
        this.fIsEditable = editable;
    }

    public String getInitializerCount() {
        return Integer.toString(this.fInitializerCount++);
    }

    public String extractMethodName() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos > 0) {
            return id.substring(1, pos);
        }
        return id.substring(1);
    }

    public String extractArgumentList() {
        String id = this.getId();
        int pos = id.indexOf(40);
        if (pos >= 0) {
            return id.substring(pos + 1);
        }
        return id.substring(1);
    }

    public String getName() {
        switch (this.getTypeCode()) {
            case 2: {
                return CompareMessages.RubyNode_importDeclarations;
            }
            case 0: {
                return CompareMessages.RubyNode_script;
            }
        }
        return this.getId().substring(1);
    }

    public String getType() {
        return "java2";
    }

    public boolean isEditable() {
        return this.fIsEditable;
    }

    public Image getImage() {
        ImageDescriptor id = null;
        switch (this.getTypeCode()) {
            case 0: {
                id = RubyCompareUtilities.getImageDescriptor(4);
                break;
            }
            case 3: {
                id = RubyCompareUtilities.getImageDescriptor(8);
                break;
            }
            case 2: {
                id = RubyCompareUtilities.getImageDescriptor(16);
                break;
            }
            case 5: {
                id = RubyCompareUtilities.getTypeImageDescriptor(true);
                break;
            }
            case 4: {
                id = RubyCompareUtilities.getTypeImageDescriptor(false);
                break;
            }
            case 10: 
            case 11: {
                id = RubyCompareUtilities.getImageDescriptor(6);
                break;
            }
            case 8: {
                id = RubyCompareUtilities.getImageDescriptor(15);
            }
        }
        return RubyPlugin.getImageDescriptorRegistry().get(id);
    }

    public void setContent(byte[] content) {
        super.setContent(content);
        this.nodeChanged(this);
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        this.nodeChanged(this);
        return child;
    }

    void nodeChanged(RubyNode node) {
        if (this.fParent != null) {
            this.fParent.nodeChanged(node);
        }
    }
}

