/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.internal.corext.callhierarchy.MethodWrapper;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.rubypeople.rdt.internal.ui.util.SelectionUtil;

class FocusOnSelectionAction
extends Action {
    private CallHierarchyViewPart fPart;

    public FocusOnSelectionAction(CallHierarchyViewPart part) {
        super(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_text);
        this.fPart = part;
        this.setDescription(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_description);
        this.setToolTipText(CallHierarchyMessages.FocusOnSelectionAction_focusOnSelection_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.call_hierarchy_focus_on_selection_action_context");
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        IMethod method = this.getSelectedMethod(element);
        if (method != null) {
            this.setText(Messages.format(CallHierarchyMessages.FocusOnSelectionAction_focusOn_text, method.getElementName()));
            return true;
        }
        return false;
    }

    private IMethod getSelectedMethod(Object element) {
        IMember member;
        IMethod method = null;
        if (element instanceof IMethod) {
            method = (IMethod)element;
        } else if (element instanceof MethodWrapper && (member = ((MethodWrapper)((Object)element)).getMember()).getElementType() == 6) {
            method = (IMethod)member;
        }
        return method;
    }

    public void run() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        IMethod method = this.getSelectedMethod(element);
        if (method != null) {
            this.fPart.setMethod(method);
        }
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }
}

