/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.callhierarchy;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.corext.callhierarchy.CallHierarchy;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.rubypeople.rdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;

class FiltersDialog
extends StatusDialog {
    private Label fNamesHelpText;
    private Button fFilterOnNames;
    private Text fNames;
    private Text fMaxCallDepth;

    protected FiltersDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CallHierarchyMessages.FiltersDialog_filter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.rubypeople.rdt.ui.call_hierarchy_filters_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        composite.setFont(superComposite.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.createNamesArea(composite);
        new Label(composite, 0);
        this.createMaxCallDepthArea(composite);
        this.updateUIFromFilter();
        return composite;
    }

    private void createMaxCallDepthArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(CallHierarchyMessages.FiltersDialog_maxCallDepth);
        this.fMaxCallDepth = new Text(composite, 2052);
        this.fMaxCallDepth.setFont(composite.getFont());
        this.fMaxCallDepth.setTextLimit(6);
        this.fMaxCallDepth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.fMaxCallDepth.setLayoutData((Object)gridData);
    }

    private void createNamesArea(Composite parent) {
        this.fFilterOnNames = this.createCheckbox(parent, CallHierarchyMessages.FiltersDialog_filterOnNames, true);
        this.fNames = new Text(parent, 2052);
        this.fNames.setFont(parent.getFont());
        this.fNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNames.setLayoutData((Object)gridData);
        this.fNamesHelpText = new Label(parent, 16384);
        this.fNamesHelpText.setFont(parent.getFont());
        this.fNamesHelpText.setText(CallHierarchyMessages.FiltersDialog_filterOnNamesSubCaption);
    }

    private Button createCheckbox(Composite parent, String text, boolean grabRow) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        if (grabRow) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.validateInput();
                FiltersDialog.this.updateEnabledState();
            }
        });
        return button;
    }

    private void updateEnabledState() {
        this.fNames.setEnabled(this.fFilterOnNames.getSelection());
        this.fNamesHelpText.setEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateFilterFromUI() {
        int maxCallDepth = Integer.parseInt(this.fMaxCallDepth.getText());
        CallHierarchyUI.getDefault().setMaxCallDepth(maxCallDepth);
        CallHierarchy.getDefault().setFilters(this.fNames.getText());
        CallHierarchy.getDefault().setFilterEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateUIFromFilter() {
        this.fMaxCallDepth.setText(String.valueOf(CallHierarchyUI.getDefault().getMaxCallDepth()));
        this.fNames.setText(CallHierarchy.getDefault().getFilters());
        this.fFilterOnNames.setSelection(CallHierarchy.getDefault().isFilterEnabled());
        this.updateEnabledState();
    }

    protected void okPressed() {
        if (!this.isMaxCallDepthValid() && this.fMaxCallDepth.forceFocus()) {
            this.fMaxCallDepth.setSelection(0, this.fMaxCallDepth.getCharCount());
            this.fMaxCallDepth.showSelection();
        }
        this.updateFilterFromUI();
        super.okPressed();
    }

    private boolean isMaxCallDepthValid() {
        String text = this.fMaxCallDepth.getText();
        if (text.length() == 0) {
            return false;
        }
        try {
            int maxCallDepth = Integer.parseInt(text);
            return maxCallDepth >= 1 && maxCallDepth <= 99;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void validateInput() {
        StatusInfo status = new StatusInfo();
        if (!this.isMaxCallDepthValid()) {
            status.setError(CallHierarchyMessages.FiltersDialog_messageMaxCallDepthInvalid);
        }
        this.updateStatus(status);
    }
}

