/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.browsing.ProjectAndSourceFolderContentProvider;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.internal.ui.viewsupport.FilterUpdater;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.rubypeople.rdt.ui.actions.ProjectActionGroup;

public class ProjectsView
extends RubyBrowsingPart {
    private FilterUpdater fFilterUpdater;

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer result = new ProblemTreeViewer(parent, 2);
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)result);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        return result;
    }

    public void dispose() {
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected IContentProvider createContentProvider() {
        return new ProjectAndSourceFolderContentProvider(this);
    }

    protected String getHelpContextId() {
        return "org.rubypeople.rdt.ui.projects_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.rubypeople.rdt.ui.browsing.projectstoeditor";
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)ProjectsView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    protected void setInitialInput() {
        IRubyModel root = RubyCore.create((IWorkspaceRoot)RubyPlugin.getWorkspace().getRoot());
        this.getViewer().setInput((Object)root);
        this.updateTitle();
    }

    protected boolean isValidInput(Object element) {
        return element instanceof IRubyModel;
    }

    protected boolean isValidElement(Object element) {
        return element instanceof IRubyProject || element instanceof ISourceFolderRoot;
    }

    protected IRubyElement findElementToSelect(IRubyElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 0: {
                return null;
            }
            case 1: {
                return je;
            }
            case 2: {
                if (je.getElementName().equals("")) {
                    return je.getParent();
                }
                return je;
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    protected void setInput(Object input) {
        if (input != null) {
            super.setInput(input);
        } else {
            this.getViewer().setSelection(null);
        }
    }

    protected void createActions() {
        super.createActions();
        this.fActionGroups.addGroup(new ProjectActionGroup((IViewPart)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        super.selectionChanged(part, selection);
    }
}

