/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.LexicalSortingAction;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingPart;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.ColoredViewersManager;
import org.rubypeople.rdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.actions.MemberFilterActionGroup;

public class MembersView
extends RubyBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;

    public MembersView() {
        this.setHasCustomSetFilter(true);
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected RubyUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x210000000002L, 1);
    }

    protected String getLinkToEditorKey() {
        return "org.rubypeople.rdt.ui.browsing.memberstoeditor";
    }

    protected boolean isValidInput(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null;
        }
        return false;
    }

    protected boolean isValidElement(Object element) {
        IRubyScript cu;
        Object input;
        if (element instanceof IMember) {
            return super.isValidElement(((IMember)element).getDeclaringType());
        }
        if (element instanceof IImportDeclaration) {
            return this.isValidElement(((IRubyElement)element).getParent());
        }
        if (element instanceof IImportContainer && (input = this.getViewer().getInput()) instanceof IRubyElement && (cu = (IRubyScript)((IRubyElement)input).getAncestor(4)) != null) {
            IRubyScript importContainerCu = (IRubyScript)((IRubyElement)element).getAncestor(4);
            return cu.equals(importContainerCu);
        }
        return false;
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                TreeViewer viewer = (TreeViewer)MembersView.this.getViewer();
                if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        });
    }

    protected IRubyElement findElementToSelect(IRubyElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 5: {
                if (((IType)je).getDeclaringType() == null) {
                    return null;
                }
            }
            case 6: 
            case 15: 
            case 16: {
                return this.getSuitableRubyElement(je);
            }
            case 8: {
                je = this.getSuitableRubyElement(je);
                if (je == null) break;
                IRubyScript cu = (IRubyScript)je.getParent().getParent();
                try {
                    Object selectedElement;
                    if (cu.getImports()[0].equals(je) && (selectedElement = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)selectedElement;
                    }
                }
                catch (RubyModelException rubyModelException) {}
                return je;
            }
        }
        return null;
    }

    protected IRubyElement findInputForRubyElement(IRubyElement je) {
        if (je == null || !je.exists()) {
            return null;
        }
        switch (je.getElementType()) {
            case 5: {
                return je;
            }
            case 4: {
                return this.getTypeForRubyScript((IRubyScript)je);
            }
            case 8: {
                return this.findInputForRubyElement(je.getParent());
            }
            case 16: {
                IRubyElement parent = je.getParent();
                if (!(parent instanceof IRubyScript)) break;
                return this.getTypeForRubyScript((IRubyScript)parent);
            }
        }
        if (je instanceof IMember) {
            return this.findInputForRubyElement((IRubyElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    boolean isInputAWorkingCopy() {
        IRubyScript cu;
        Object input = this.getViewer().getInput();
        if (input instanceof IRubyElement && (cu = (IRubyScript)((IRubyElement)input).getAncestor(4)) != null) {
            return cu.isWorkingCopy();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        super.dispose();
        RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected StructuredViewer createViewer(Composite parent) {
        ProblemTreeViewer viewer = new ProblemTreeViewer(parent, 2);
        ColoredViewersManager.install((StructuredViewer)viewer);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)viewer, RubyUI.ID_MEMBERS_VIEW);
        return viewer;
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)new LexicalSortingAction(this.getViewer(), RubyUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(tbm);
        super.fillToolBar(tbm);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object selectedElement = sel.getFirstElement();
            if (sel.size() == 1 && selectedElement instanceof LogicalType) {
                IType[] fragments = ((LogicalType)selectedElement).getOriginalTypes();
                List<IType> selectedElements = Arrays.asList(fragments);
                if (selectedElements.size() > 1) {
                    this.adjustInput(part, selectedElements);
                    this.fPreviousSelectedElement = selectedElements;
                    this.fPreviousSelectionProvider = part;
                } else if (selectedElements.size() == 1) {
                    super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
                } else {
                    Assert.isLegal((boolean)false);
                }
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(IWorkbenchPart part, List selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }
}

