/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.rubypeople.rdt.core.ICodeAssist;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;

public class SelectionConverter {
    private static final IRubyElement[] EMPTY_RESULT = new IRubyElement[0];

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws RubyModelException {
        ISelection selection;
        if (part instanceof RubyEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((AbstractTextEditor)((RubyEditor)part)));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IRubyElement getElementAtOffset(RubyEditor editor) throws RubyModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IRubyElement getElementAtOffset(RubyEditor editor, boolean primaryOnly) throws RubyModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IRubyElement getElementAtOffset(IRubyElement input, ITextSelection selection) throws RubyModelException {
        if (input instanceof IRubyScript) {
            IRubyScript cunit = (IRubyScript)input;
            RubyModelUtil.reconcile(cunit);
            IRubyElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IRubyScript getInputAsRubyScript(RubyEditor editor) {
        IRubyElement editorInput = SelectionConverter.getInput((IEditorPart)editor);
        if (editorInput instanceof IRubyScript) {
            return (IRubyScript)editorInput;
        }
        return null;
    }

    public static IRubyElement getInput(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IRubyScriptEditorInput) {
            IRubyScriptEditorInput scriptEditor = (IRubyScriptEditorInput)input;
            return scriptEditor.getRubyScript();
        }
        WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public static boolean canOperateOn(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IRubyElement codeResolve(AbstractTextEditor editor, Shell shell, String title, String message) throws RubyModelException {
        IRubyElement[] elements = SelectionConverter.codeResolve(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        IRubyElement candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectRubyElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static IRubyElement[] codeResolve(AbstractTextEditor editor) throws RubyModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput((IEditorPart)editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IRubyElement[] codeResolve(IRubyElement input, ITextSelection selection) throws RubyModelException {
        return SelectionConverter.codeResolve(input, selection.getOffset(), selection.getLength());
    }

    public static IRubyElement[] codeResolve(IRubyElement input, int offset, int length) throws RubyModelException {
        if (input instanceof ICodeAssist) {
            IRubyElement[] elements;
            if (input instanceof IRubyScript) {
                RubyModelUtil.reconcile((IRubyScript)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(offset, length)) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IRubyElement[] codeResolveForked(RubyEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    private static IRubyElement getInput(RubyEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputRubyElement((IEditorPart)editor, primaryOnly);
    }

    private static IRubyElement[] performForkedCodeResolve(IRubyElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IRubyElement[] result;
            private final /* synthetic */ IRubyElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IRubyElement iRubyElement, ITextSelection iTextSelection) {
                this.val$input = iRubyElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (RubyModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IRubyElement[] codeResolveOrInputForked(RubyEditor editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IRubyElement input = SelectionConverter.getInput((IEditorPart)editor);
        IRubyElement[] result = SelectionConverter.performForkedCodeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IRubyElement[]{input};
        }
        return result;
    }

    public static IRubyElement resolveEnclosingElement(RubyEditor editor, ITextSelection selection) throws RubyModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput((IEditorPart)editor), selection);
    }

    public static IRubyElement resolveEnclosingElement(IRubyElement input, ITextSelection selection) throws RubyModelException {
        IRubyElement atOffset = null;
        if (!(input instanceof IRubyScript)) {
            return null;
        }
        IRubyScript cunit = (IRubyScript)input;
        RubyModelUtil.reconcile(cunit);
        atOffset = cunit.getElementAt(selection.getOffset());
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IRubyElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }
}

