/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.NewWizardMenu;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;

public class NewWizardsActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;

    public NewWizardsActionGroup(IWorkbenchSite site) {
        this.fSite = site;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sel;
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() <= 1 && this.isNewTarget(sel.getFirstElement())) {
            MenuManager newMenu = new MenuManager(ActionMessages.NewWizardsActionGroup_new);
            menu.appendToGroup("group.new", (IContributionItem)newMenu);
            newMenu.add((IContributionItem)new NewWizardMenu(this.fSite.getWorkbenchWindow()));
        }
    }

    private boolean isNewTarget(Object element) {
        if (element == null) {
            return true;
        }
        if (element instanceof IResource) {
            return true;
        }
        if (element instanceof IRubyElement) {
            int type = ((IRubyElement)element).getElementType();
            return type == 1 || type == 2 || type == 3 || type == 4 || type == 5;
        }
        return false;
    }
}

